/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.computed.text;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.text.TextStyleKeys;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.ResolveHandler;

public class TextKashidaSpaceResolveHandler
implements ResolveHandler {
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[0];
    }

    public void resolve(LayoutProcess process, LayoutElement currentNode, StyleKey key) {
        LayoutContext layoutContext = currentNode.getLayoutContext();
        CSSValue value = layoutContext.getValue(key);
        if (!(value instanceof CSSNumericValue)) {
            return;
        }
        CSSNumericValue nval = (CSSNumericValue)value;
        if (!CSSNumericType.PERCENTAGE.equals(nval.getType())) {
            return;
        }
        double percentage = nval.getValue();
        if (percentage < 0.0) {
            percentage = 0.0;
        }
        if (percentage > 100.0) {
            percentage = 100.0;
        }
        layoutContext.setValue(TextStyleKeys.TEXT_KASHIDA_SPACE, CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, percentage));
    }
}

