/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.computed.fonts;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.font.FontStyleKeys;
import org.jfree.layouting.input.style.keys.font.FontWeight;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.ResolveHandler;

public class FontWeightResolveHandler
implements ResolveHandler {
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[0];
    }

    public void resolve(LayoutProcess process, LayoutElement currentNode, StyleKey key) {
        int fontWeight;
        LayoutContext layoutContext = currentNode.getLayoutContext();
        CSSValue value = layoutContext.getValue(key);
        if (FontWeight.BOLD.equals(value)) {
            fontWeight = 700;
        } else if (FontWeight.NORMAL.equals(value)) {
            fontWeight = 400;
        } else if (FontWeight.BOLDER.equals(value)) {
            int parentFontWeight = this.queryParent(currentNode.getParent());
            fontWeight = Math.max(900, parentFontWeight + 100);
        } else if (FontWeight.LIGHTER.equals(value)) {
            int parentFontWeight = this.queryParent(currentNode.getParent());
            fontWeight = Math.min(100, parentFontWeight - 100);
        } else {
            CSSNumericValue nval;
            fontWeight = value instanceof CSSNumericValue ? (!CSSNumericType.NUMBER.equals((nval = (CSSNumericValue)value).getType()) ? this.queryParent(currentNode.getParent()) : (int)nval.getValue()) : this.queryParent(currentNode.getParent());
        }
        layoutContext.setValue(FontStyleKeys.FONT_WEIGHT, CSSNumericValue.createValue(CSSNumericType.NUMBER, fontWeight));
    }

    private int queryParent(LayoutElement parent) {
        if (parent == null) {
            return 400;
        }
        return parent.getLayoutContext().getFontSpecification().getFontWeight();
    }
}

