/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.computed.fonts;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.font.FontStretch;
import org.jfree.layouting.input.style.keys.font.FontStyleKeys;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.computed.ConstantsResolveHandler;
import org.jfree.util.Log;

public class FontStretchResolveHandler
extends ConstantsResolveHandler {
    public FontStretchResolveHandler() {
        this.addNormalizeValue(FontStretch.CONDENSED);
        this.addNormalizeValue(FontStretch.EXPANDED);
        this.addNormalizeValue(FontStretch.EXTRA_CONDENSED);
        this.addNormalizeValue(FontStretch.EXTRA_EXPANDED);
        this.addNormalizeValue(FontStretch.NORMAL);
        this.addNormalizeValue(FontStretch.SEMI_CONDENSED);
        this.addNormalizeValue(FontStretch.SEMI_EXPANDED);
        this.addNormalizeValue(FontStretch.ULTRA_CONDENSED);
        this.addNormalizeValue(FontStretch.ULTRA_EXPANDED);
    }

    public void resolve(LayoutProcess process, LayoutElement currentNode, StyleKey key) {
        CSSConstant result;
        LayoutContext layoutContext = currentNode.getLayoutContext();
        CSSValue value = layoutContext.getValue(key);
        if (FontStretch.WIDER.equals(value)) {
            CSSConstant parentStretch = this.queryParent(currentNode.getParent());
            result = FontStretch.getByOrder(FontStretch.getOrder(parentStretch) + 1);
        } else if (FontStretch.NARROWER.equals(value)) {
            CSSConstant parentStretch = this.queryParent(currentNode.getParent());
            result = FontStretch.getByOrder(FontStretch.getOrder(parentStretch) - 1);
        } else {
            CSSConstant stretch;
            result = value instanceof CSSConstant ? ((stretch = (CSSConstant)this.lookupValue((CSSConstant)value)) != null ? stretch : FontStretch.NORMAL) : FontStretch.NORMAL;
        }
        layoutContext.setValue(key, result);
    }

    private CSSConstant queryParent(LayoutElement parent) {
        if (parent == null) {
            return FontStretch.NORMAL;
        }
        CSSValue parentValue = parent.getLayoutContext().getValue(FontStyleKeys.FONT_STRETCH);
        if (parentValue == null) {
            Log.error((Object)"Assertation failed: Parent stretch is null");
            return FontStretch.NORMAL;
        }
        return FontStretch.getByOrder(FontStretch.getOrder(parentValue));
    }
}

