/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.computed.fonts;

import org.jfree.fonts.registry.FontFamily;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.font.FontFamilyValues;
import org.jfree.layouting.input.style.keys.font.FontStyleKeys;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSStringValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValueList;
import org.jfree.layouting.layouter.context.FontSpecification;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.computed.ConstantsResolveHandler;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.util.Log;

public class FontFamilyResolveHandler
extends ConstantsResolveHandler {
    public FontFamilyResolveHandler() {
        this.addNormalizeValue(FontFamilyValues.CURSIVE);
        this.addNormalizeValue(FontFamilyValues.FANTASY);
        this.addNormalizeValue(FontFamilyValues.MONOSPACE);
        this.addNormalizeValue(FontFamilyValues.SANS_SERIF);
        this.addNormalizeValue(FontFamilyValues.SERIF);
    }

    public StyleKey[] getRequiredStyles() {
        return new StyleKey[]{FontStyleKeys.FONT_WEIGHT, FontStyleKeys.FONT_VARIANT, FontStyleKeys.FONT_SMOOTH, FontStyleKeys.FONT_STRETCH};
    }

    public void resolve(LayoutProcess process, LayoutElement currentNode, StyleKey key) {
        LayoutContext layoutContext = currentNode.getLayoutContext();
        FontSpecification fs = layoutContext.getFontSpecification();
        OutputProcessorMetaData outputMetaData = process.getOutputMetaData();
        CSSValue cssValue = layoutContext.getValue(key);
        if (cssValue instanceof CSSValueList) {
            CSSValueList list = (CSSValueList)cssValue;
            for (int i = 0; i < list.getLength(); ++i) {
                CSSValue item = list.getItem(i);
                if (item instanceof CSSConstant) {
                    CSSConstant c = (CSSConstant)this.lookupValue((CSSConstant)item);
                    FontFamily family = outputMetaData.getFontFamilyForGenericName(c);
                    fs.setFontFamily(family.getFamilyName());
                    if (process.getOutputMetaData().isValid(fs)) {
                        return;
                    }
                    Log.warn((Object)"Invalid state after setting predefined font family.");
                    continue;
                }
                if (!(item instanceof CSSStringValue)) continue;
                CSSStringValue sval = (CSSStringValue)item;
                String fontName = sval.getValue();
                fs.setFontFamily(fontName);
                if (!process.getOutputMetaData().isValid(fs)) continue;
                return;
            }
        } else if (cssValue instanceof CSSConstant && FontFamilyValues.NONE.equals(cssValue)) {
            Log.info((Object)"Font family has been set to 'none'.");
            fs.setFontFamily(null);
            return;
        }
        FontFamily family = outputMetaData.getDefaultFontFamily();
        fs.setFontFamily(family.getFamilyName());
        if (!process.getOutputMetaData().isValid(fs)) {
            throw new IllegalStateException("Invalid state after setting the default font family.");
        }
    }
}

