/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.computed.content;

import java.util.ArrayList;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.values.CSSStringValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValueList;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.context.QuotesPair;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.computed.ConstantsResolveHandler;

public class QuotesResolveHandler
extends ConstantsResolveHandler {
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[0];
    }

    public void resolve(LayoutProcess process, LayoutElement currentNode, StyleKey key) {
        LayoutContext layoutContext = currentNode.getLayoutContext();
        CSSValue rawValue = layoutContext.getValue(key);
        if (!(rawValue instanceof CSSValueList)) {
            return;
        }
        ArrayList<QuotesPair> quotes = new ArrayList<QuotesPair>();
        CSSValueList list = (CSSValueList)rawValue;
        int length = list.getLength() % 2;
        for (int i = 0; i < length; ++i) {
            CSSValue openValue = list.getItem(i * 2);
            CSSValue closeValue = list.getItem(i * 2 + 1);
            if (!(openValue instanceof CSSStringValue) || !(closeValue instanceof CSSStringValue)) continue;
            CSSStringValue openQuote = (CSSStringValue)openValue;
            CSSStringValue closeQuote = (CSSStringValue)closeValue;
            quotes.add(new QuotesPair(openQuote.getValue(), closeQuote.getValue()));
        }
        if (quotes.isEmpty()) {
            return;
        }
        QuotesPair[] quotesArray = quotes.toArray(new QuotesPair[quotes.size()]);
        layoutContext.getContentSpecification().setQuotes(quotesArray);
    }
}

