/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.computed.content;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.content.ContentStyleKeys;
import org.jfree.layouting.input.style.keys.content.MoveToValues;
import org.jfree.layouting.input.style.values.CSSStringType;
import org.jfree.layouting.input.style.values.CSSStringValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.content.ContentToken;
import org.jfree.layouting.layouter.content.computed.ComputedToken;
import org.jfree.layouting.layouter.content.computed.CounterToken;
import org.jfree.layouting.layouter.content.computed.CountersToken;
import org.jfree.layouting.layouter.content.resolved.ResolvedCounterToken;
import org.jfree.layouting.layouter.context.ContentSpecification;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.ResolveHandler;

public class MoveToResolveHandler
implements ResolveHandler {
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[0];
    }

    private boolean isCounterUsed(LayoutElement element, String counter) {
        LayoutContext layoutContext = element.getLayoutContext();
        ContentSpecification contentSpecification = layoutContext.getContentSpecification();
        ContentToken[] contents = contentSpecification.getContents();
        for (int i = 0; i < contents.length; ++i) {
            ComputedToken counterToken;
            ContentToken content = contents[i];
            if (content instanceof ResolvedCounterToken) {
                ResolvedCounterToken computedToken = (ResolvedCounterToken)content;
                content = computedToken.getParent();
            }
            if (!(content instanceof CounterToken ? ((CounterToken)(counterToken = (CounterToken)content)).getName().equals(counter) : content instanceof CountersToken && ((CountersToken)(counterToken = (CountersToken)content)).getName().equals(counter))) continue;
            return true;
        }
        return false;
    }

    public void resolve(LayoutProcess process, LayoutElement currentNode, StyleKey key) {
        LayoutContext layoutContext = currentNode.getLayoutContext();
        CSSValue value = layoutContext.getValue(ContentStyleKeys.MOVE_TO);
        if (MoveToValues.NORMAL.equals(value)) {
            if ("alternate".equals(layoutContext.getPseudoElement())) {
                if (this.isCounterUsed(currentNode.getParent(), "footnote")) {
                    layoutContext.setValue(ContentStyleKeys.MOVE_TO, new CSSStringValue(CSSStringType.STRING, "footnotes"));
                    return;
                }
                if (this.isCounterUsed(currentNode.getParent(), "endnote")) {
                    layoutContext.setValue(ContentStyleKeys.MOVE_TO, new CSSStringValue(CSSStringType.STRING, "endnotes"));
                    return;
                }
                if (this.isCounterUsed(currentNode.getParent(), "section-note")) {
                    layoutContext.setValue(ContentStyleKeys.MOVE_TO, new CSSStringValue(CSSStringType.STRING, "section-notes"));
                    return;
                }
            }
            layoutContext.setValue(ContentStyleKeys.MOVE_TO, MoveToValues.HERE);
        }
    }
}

