/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.computed.content;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.jfree.layouting.DocumentContextUtility;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.box.BoxStyleKeys;
import org.jfree.layouting.input.style.keys.box.DisplayRole;
import org.jfree.layouting.input.style.keys.content.ContentStyleKeys;
import org.jfree.layouting.input.style.keys.content.ContentValues;
import org.jfree.layouting.input.style.keys.list.ListStyleKeys;
import org.jfree.layouting.input.style.values.CSSAttrFunction;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSFunctionValue;
import org.jfree.layouting.input.style.values.CSSStringType;
import org.jfree.layouting.input.style.values.CSSStringValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValueList;
import org.jfree.layouting.layouter.content.ContentToken;
import org.jfree.layouting.layouter.content.computed.CloseQuoteToken;
import org.jfree.layouting.layouter.content.computed.ContentsToken;
import org.jfree.layouting.layouter.content.computed.CounterToken;
import org.jfree.layouting.layouter.content.computed.OpenQuoteToken;
import org.jfree.layouting.layouter.content.statics.StaticTextToken;
import org.jfree.layouting.layouter.context.ContentSpecification;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.counters.CounterStyle;
import org.jfree.layouting.layouter.counters.CounterStyleFactory;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.functions.FunctionEvaluationException;
import org.jfree.layouting.layouter.style.functions.FunctionFactory;
import org.jfree.layouting.layouter.style.functions.content.ContentFunction;
import org.jfree.layouting.layouter.style.resolver.ResolveHandler;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceManager;
import org.jfree.util.Log;

public class ContentResolveHandler
implements ResolveHandler {
    private static final ContentToken[] DEFAULT_CONTENT = new ContentToken[]{ContentsToken.CONTENTS};
    private static final ContentToken[] PSEUDO_CONTENT = new ContentToken[0];
    private CSSValue listCounter;
    private HashMap tokenMapping = new HashMap();

    public ContentResolveHandler() {
        this.tokenMapping.put(ContentValues.CONTENTS, ContentsToken.CONTENTS);
        this.tokenMapping.put(ContentValues.OPEN_QUOTE, new OpenQuoteToken(false));
        this.tokenMapping.put(ContentValues.NO_OPEN_QUOTE, new OpenQuoteToken(true));
        this.tokenMapping.put(ContentValues.CLOSE_QUOTE, new CloseQuoteToken(false));
        this.tokenMapping.put(ContentValues.NO_CLOSE_QUOTE, new CloseQuoteToken(true));
        CSSStringValue param = new CSSStringValue(CSSStringType.STRING, "list-item");
        this.listCounter = new CSSFunctionValue("counter", new CSSValue[]{param});
    }

    public StyleKey[] getRequiredStyles() {
        return new StyleKey[]{ContentStyleKeys.COUNTER_RESET, ContentStyleKeys.COUNTER_INCREMENT, ContentStyleKeys.QUOTES, ContentStyleKeys.STRING_SET};
    }

    public void resolve(LayoutProcess process, LayoutElement element, StyleKey key) {
        LayoutContext layoutContext = element.getLayoutContext();
        ContentSpecification contentSpecification = layoutContext.getContentSpecification();
        CSSValue value = layoutContext.getValue(key);
        if (value instanceof CSSConstant) {
            if (ContentValues.NONE.equals(value)) {
                contentSpecification.setAllowContentProcessing(false);
                contentSpecification.setInhibitContent(false);
                contentSpecification.setContents(PSEUDO_CONTENT);
                return;
            }
            if (ContentValues.INHIBIT.equals(value)) {
                contentSpecification.setAllowContentProcessing(false);
                contentSpecification.setInhibitContent(true);
                contentSpecification.setContents(PSEUDO_CONTENT);
                return;
            }
            if (ContentValues.NORMAL.equals(value) && layoutContext.isPseudoElement()) {
                if (this.isListMarker(element)) {
                    this.processListItem(process, element, contentSpecification);
                    return;
                }
                contentSpecification.setAllowContentProcessing(false);
                contentSpecification.setInhibitContent(true);
                contentSpecification.setContents(PSEUDO_CONTENT);
                return;
            }
        }
        contentSpecification.setInhibitContent(false);
        contentSpecification.setAllowContentProcessing(true);
        contentSpecification.setContents(DEFAULT_CONTENT);
        if (value instanceof CSSAttrFunction) {
            ContentToken token = this.evaluateFunction((CSSFunctionValue)value, process, element);
            if (token == null) {
                return;
            }
            contentSpecification.setContents(new ContentToken[]{token});
        }
        if (!(value instanceof CSSValueList)) {
            return;
        }
        ArrayList<ContentToken> tokens = new ArrayList<ContentToken>();
        CSSValueList list = (CSSValueList)value;
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            CSSValueList sequence = (CSSValueList)list.getItem(i);
            for (int j = 0; j < sequence.getLength(); ++j) {
                CSSValue content = sequence.getItem(j);
                ContentToken token = this.createToken(process, element, content);
                if (token == null) {
                    tokens.clear();
                    break;
                }
                tokens.add(token);
            }
            if (tokens.isEmpty()) continue;
            ContentToken[] contents = tokens.toArray(new ContentToken[tokens.size()]);
            contentSpecification.setContents(contents);
            return;
        }
    }

    private void processListItem(LayoutProcess process, LayoutElement element, ContentSpecification contentSpecification) {
        ContentToken token;
        contentSpecification.setAllowContentProcessing(false);
        contentSpecification.setInhibitContent(false);
        LayoutContext layoutContext = element.getLayoutContext();
        CSSValue value = layoutContext.getValue(ListStyleKeys.LIST_STYLE_IMAGE);
        if (value != null && (token = this.createToken(process, element, value)) != null) {
            contentSpecification.setContents(new ContentToken[]{token});
            return;
        }
        token = this.createToken(process, element, this.listCounter);
        if (token instanceof CounterToken) {
            CounterToken counterToken = (CounterToken)token;
            CounterStyle style = counterToken.getStyle();
            String suffix = style.getSuffix();
            if (suffix == null || suffix.length() == 0) {
                contentSpecification.setContents(new ContentToken[]{token});
            } else {
                contentSpecification.setContents(new ContentToken[]{counterToken, new StaticTextToken(suffix)});
            }
        } else {
            contentSpecification.setContents(new ContentToken[]{token});
        }
    }

    private boolean isListMarker(LayoutElement element) {
        LayoutContext layoutContext = element.getLayoutContext();
        if (!"marker".equals(layoutContext.getPseudoElement())) {
            return false;
        }
        LayoutElement parent = element.getParent();
        if (parent == null) {
            return false;
        }
        CSSValue parentDisplayRole = parent.getLayoutContext().getValue(BoxStyleKeys.DISPLAY_ROLE);
        return DisplayRole.LIST_ITEM.equals(parentDisplayRole);
    }

    private ContentToken createToken(LayoutProcess process, LayoutElement element, CSSValue content) {
        try {
            if (content instanceof CSSStringValue) {
                CSSStringValue sval = (CSSStringValue)content;
                if (CSSStringType.STRING.equals(sval.getType())) {
                    return new StaticTextToken(sval.getValue());
                }
                CSSFunctionValue function = new CSSFunctionValue("url", new CSSValue[]{sval});
                return this.evaluateFunction(function, process, element);
            }
            if (content instanceof CSSConstant) {
                if (ContentValues.DOCUMENT_URL.equals(content)) {
                    Object docUrl = process.getDocumentContext().getMetaAttribute("document-url");
                    if (docUrl != null) {
                        return new StaticTextToken(String.valueOf(docUrl));
                    }
                    ResourceKey baseKey = DocumentContextUtility.getBaseResource(process.getDocumentContext());
                    ResourceManager resourceManager = DocumentContextUtility.getResourceManager(process.getDocumentContext());
                    URL url = resourceManager.toURL(baseKey);
                    if (url != null) {
                        return new StaticTextToken(url.toExternalForm());
                    }
                    return null;
                }
                ContentToken token = (ContentToken)this.tokenMapping.get(content);
                if (token != null) {
                    return token;
                }
                return this.resolveContentAlias(content);
            }
            if (content instanceof CSSFunctionValue) {
                return this.evaluateFunction((CSSFunctionValue)content, process, element);
            }
        }
        catch (Exception e) {
            Log.debug((Object)("Content-Resolver: Failed to evaluate " + content));
        }
        return null;
    }

    private ContentToken resolveContentAlias(CSSValue content) {
        if (ContentValues.FOOTNOTE.equals(content)) {
            CounterStyle style = CounterStyleFactory.getInstance().getCounterStyle("normal");
            return new CounterToken("footnote", style);
        }
        if (ContentValues.ENDNOTE.equals(content)) {
            CounterStyle style = CounterStyleFactory.getInstance().getCounterStyle("normal");
            return new CounterToken("endnote", style);
        }
        if (ContentValues.SECTIONNOTE.equals(content)) {
            CounterStyle style = CounterStyleFactory.getInstance().getCounterStyle("normal");
            return new CounterToken("section-note", style);
        }
        if (ContentValues.LISTITEM.equals(content)) {
            CounterStyle style = CounterStyleFactory.getInstance().getCounterStyle("normal");
            return new CounterToken("list-item", style);
        }
        return null;
    }

    private ContentToken evaluateFunction(CSSFunctionValue function, LayoutProcess process, LayoutElement element) {
        ContentFunction styleFunction = FunctionFactory.getInstance().getContentFunction(function.getFunctionName());
        if (styleFunction == null) {
            return null;
        }
        try {
            return styleFunction.evaluate(process, element, function);
        }
        catch (FunctionEvaluationException e) {
            Log.debug((Object)("Evaluation failed " + (Object)((Object)e)));
            return null;
        }
    }
}

