/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.computed.border;

import org.jfree.layouting.DocumentContextUtility;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.values.CSSStringValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValueList;
import org.jfree.layouting.layouter.context.BackgroundSpecification;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.CSSValueResolverUtility;
import org.jfree.layouting.layouter.style.resolver.ResolveHandler;
import org.jfree.layouting.output.OutputProcessorFeature;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceKeyCreationException;

public class BackgroundImageResolveHandler
implements ResolveHandler {
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[0];
    }

    public void resolve(LayoutProcess process, LayoutElement currentNode, StyleKey key) {
        if (!process.getOutputMetaData().isFeatureSupported(OutputProcessorFeature.BACKGROUND_IMAGE)) {
            return;
        }
        LayoutContext layoutContext = currentNode.getLayoutContext();
        CSSValue value = layoutContext.getValue(key);
        if (value == null) {
            return;
        }
        if (!(value instanceof CSSValueList)) {
            return;
        }
        CSSValueList list = (CSSValueList)value;
        int length = list.getLength();
        if (length == 0) {
            return;
        }
        BackgroundSpecification backgroundSpecification = layoutContext.getBackgroundSpecification();
        ResourceKey baseURL = DocumentContextUtility.getBaseResource(process.getDocumentContext());
        for (int i = 0; i < length; ++i) {
            CSSValue item = list.getItem(i);
            if (!CSSValueResolverUtility.isURI(item)) continue;
            CSSStringValue svalue = (CSSStringValue)item;
            try {
                ResourceKey sourceURL = process.getResourceManager().deriveKey(baseURL, svalue.getValue());
                continue;
            }
            catch (ResourceKeyCreationException e) {
                e.printStackTrace();
            }
        }
    }
}

