/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.layouter.style.resolver.ResolveHandlerModule;
import org.jfree.util.Log;

public final class ResolveHandlerSorter {
    private ResolveHandlerSorter() {
    }

    public static ResolveHandlerModule[] sort(ResolveHandlerModule[] modules) {
        HashMap<StyleKey, SortModule> moduleMap = new HashMap<StyleKey, SortModule>();
        for (int i = 0; i < modules.length; ++i) {
            moduleMap.put(modules[i].getKey(), new SortModule(modules[i]));
        }
        Object[] sortModules = moduleMap.values().toArray(new SortModule[moduleMap.size()]);
        ArrayList parents = new ArrayList();
        for (int i = 0; i < sortModules.length; ++i) {
            SortModule sortMod = sortModules[i];
            ResolveHandlerSorter.computeSubsystemModules(sortMod, parents, moduleMap);
            parents.clear();
        }
        boolean doneWork = true;
        while (doneWork) {
            doneWork = false;
            for (int i = 0; i < sortModules.length; ++i) {
                Object mod = sortModules[i];
                int position = ResolveHandlerSorter.searchModulePosition((SortModule)mod, moduleMap);
                if (position == ((SortModule)mod).getPosition()) continue;
                ((SortModule)mod).setPosition(position);
                doneWork = true;
            }
        }
        Arrays.sort(sortModules);
        ResolveHandlerModule[] retvals = new ResolveHandlerModule[sortModules.length];
        for (int i = 0; i < sortModules.length; ++i) {
            retvals[i] = ((SortModule)sortModules[i]).getModule();
        }
        return retvals;
    }

    private static int searchModulePosition(SortModule smodule, HashMap moduleMap) {
        int position = 0;
        StyleKey[] dependentKeys = smodule.getDependentKeys();
        for (int modPos = 0; modPos < dependentKeys.length; ++modPos) {
            SortModule reqMod = (SortModule)moduleMap.get(dependentKeys[modPos]);
            if (reqMod == null || reqMod.getPosition() < position) continue;
            position = reqMod.getPosition() + 1;
        }
        return position;
    }

    private static void computeSubsystemModules(SortModule module, ArrayList parents, HashMap moduleMap) {
        if (parents.contains(module)) {
            throw new IllegalStateException("Loop detected:" + module + " (" + parents + ')');
        }
        StyleKey[] keys = module.getDependentKeys();
        parents.add(module);
        for (int i = 0; i < keys.length; ++i) {
            StyleKey key = keys[i];
            if (key.equals(module.getKey())) {
                throw new IllegalStateException("module referencing itself as dependency");
            }
            SortModule child = (SortModule)moduleMap.get(key);
            if (child == null) {
                Log.debug((Object)("Documented dependency but have no module for that one: " + key));
                continue;
            }
            ResolveHandlerSorter.computeSubsystemModules(child, parents, moduleMap);
            module.addKeys(child.getDependentKeys());
        }
        parents.remove(module);
    }

    private static class SortModule
    implements Comparable {
        private int position = -1;
        private final StyleKey key;
        private StyleKey[] dependentKeys;
        private HashSet dependentKeySet;
        private ResolveHandlerModule module;

        private SortModule(ResolveHandlerModule module) {
            this.key = module.getKey();
            this.module = module;
            this.dependentKeySet = new HashSet();
            this.addKeys(module.getDependentKeys());
        }

        public boolean isDependency(StyleKey key) {
            return this.dependentKeySet.contains(key);
        }

        public ResolveHandlerModule getModule() {
            return this.module;
        }

        public StyleKey[] getDependentKeys() {
            if (this.dependentKeys == null) {
                this.dependentKeys = this.dependentKeySet.toArray(new StyleKey[this.dependentKeySet.size()]);
            }
            return this.dependentKeys;
        }

        public void addKeys(StyleKey[] keys) {
            boolean haveAdded = false;
            for (int i = 0; i < keys.length; ++i) {
                StyleKey styleKey = keys[i];
                if (!this.dependentKeySet.add(styleKey)) continue;
                haveAdded = true;
            }
            if (haveAdded) {
                this.dependentKeys = null;
            }
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int position) {
            this.position = position;
            this.module.setWeight(position);
        }

        public StyleKey getKey() {
            return this.key;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SortModule: ");
            buffer.append(this.position);
            buffer.append(' ');
            buffer.append(this.getKey().getName());
            return buffer.toString();
        }

        public int compareTo(Object o) {
            SortModule otherModule = (SortModule)o;
            if (this.position > otherModule.position) {
                return 1;
            }
            if (this.position < otherModule.position) {
                return -1;
            }
            return 0;
        }
    }
}

