/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import org.jfree.layouting.DocumentContextUtility;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.input.style.CSSDeclarationRule;
import org.jfree.layouting.input.style.CSSPageAreaRule;
import org.jfree.layouting.input.style.CSSPageRule;
import org.jfree.layouting.input.style.CSSStyleRule;
import org.jfree.layouting.input.style.PageAreaType;
import org.jfree.layouting.input.style.PseudoPage;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.selectors.CSSSelector;
import org.jfree.layouting.input.style.selectors.SelectorWeight;
import org.jfree.layouting.input.style.values.CSSInheritValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.DocumentContext;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.context.LayoutStyle;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.CSSStyleRuleComparator;
import org.jfree.layouting.layouter.style.LayoutStyleImpl;
import org.jfree.layouting.layouter.style.resolver.AbstractStyleResolver;
import org.jfree.layouting.layouter.style.resolver.ResolverFactory;
import org.jfree.layouting.layouter.style.resolver.StyleResolver;
import org.jfree.layouting.layouter.style.resolver.StyleRuleMatcher;
import org.jfree.layouting.namespace.NamespaceCollection;
import org.jfree.layouting.namespace.NamespaceDefinition;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.resourceloader.Resource;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceManager;
import org.jfree.util.Log;

public class DefaultStyleResolver
extends AbstractStyleResolver {
    private boolean strictStyleMode;
    private StyleRuleMatcher styleRuleMatcher;
    private StyleKey[] inheritedKeys;
    static /* synthetic */ Class class$org$jfree$layouting$input$style$StyleRule;

    public void initialize(LayoutProcess layoutProcess) {
        super.initialize(layoutProcess);
        DocumentContext documentContext = layoutProcess.getDocumentContext();
        this.styleRuleMatcher = DocumentContextUtility.getStyleRuleMatcher(documentContext);
        this.styleRuleMatcher.initialize(layoutProcess);
        this.strictStyleMode = Boolean.TRUE.equals(documentContext.getMetaAttribute("strict-style-mode"));
        this.loadInitialStyle();
    }

    protected void resolveOutOfContext(LayoutElement element) {
        this.resolveStyle(element);
    }

    public boolean isPseudoElementStyleResolvable(LayoutElement element, String pseudo) {
        return this.styleRuleMatcher.isMatchingPseudoElement(element, pseudo);
    }

    public void resolveStyle(LayoutElement element) {
        LayoutStyle parentStyle;
        LayoutContext layoutContext = element.getLayoutContext();
        StyleKey[] keys = this.getKeys();
        LayoutElement parent = element.getParent();
        LayoutStyle initialStyle = this.getInitialStyle();
        if (!layoutContext.copyFrom(initialStyle)) {
            Log.debug((Object)"Failed to use fast-copy");
            for (int i = 0; i < keys.length; ++i) {
                StyleKey key = keys[i];
                layoutContext.setValue(key, initialStyle.getValue(key));
            }
        }
        if (parent != null) {
            parentStyle = parent.getLayoutContext();
            StyleKey[] inheritedKeys = this.getInheritedKeys();
            for (int i = 0; i < inheritedKeys.length; ++i) {
                StyleKey key = inheritedKeys[i];
                layoutContext.setValue(key, parentStyle.getValue(key));
            }
        } else {
            parentStyle = initialStyle;
        }
        this.performSelectionStep(element, layoutContext);
        AttributeMap attributes = layoutContext.getAttributes();
        Object libLayoutStyleValue = attributes.getAttribute("http://jfreereport.sourceforge.net/namespaces/layout", "style");
        this.addStyleFromAttribute(element, libLayoutStyleValue);
        if (this.strictStyleMode) {
            this.performStrictStyleAttr(element);
        } else {
            this.performCompleteStyleAttr(element);
        }
        CSSInheritValue inheritInstance = CSSInheritValue.getInstance();
        for (int i = 0; i < keys.length; ++i) {
            StyleKey key = keys[i];
            CSSValue value = layoutContext.getValue(key);
            if (!inheritInstance.equals(value)) continue;
            layoutContext.setValue(key, parentStyle.getValue(key));
        }
        ResolverFactory.getInstance().performResolve(this.getLayoutProcess(), element);
    }

    private StyleKey[] getInheritedKeys() {
        if (this.inheritedKeys == null) {
            StyleKey[] keys = this.getKeys();
            ArrayList<StyleKey> inheritedKeysList = new ArrayList<StyleKey>();
            for (int i = 0; i < keys.length; ++i) {
                StyleKey key = keys[i];
                if (!key.isInherited()) continue;
                inheritedKeysList.add(key);
            }
            this.inheritedKeys = inheritedKeysList.toArray(new StyleKey[inheritedKeysList.size()]);
        }
        return this.inheritedKeys;
    }

    private void performStrictStyleAttr(LayoutElement node) {
        LayoutContext layoutContext = node.getLayoutContext();
        String namespace = layoutContext.getNamespace();
        if (namespace == null) {
            return;
        }
        NamespaceCollection namespaces = this.getNamespaces();
        NamespaceDefinition ndef = namespaces.getDefinition(namespace);
        if (ndef == null) {
            return;
        }
        AttributeMap attributes = layoutContext.getAttributes();
        String[] styleAttrs = ndef.getStyleAttribute(layoutContext.getTagName());
        for (int i = 0; i < styleAttrs.length; ++i) {
            String attr = styleAttrs[i];
            Object styleValue = attributes.getAttribute(namespace, attr);
            this.addStyleFromAttribute(node, styleValue);
        }
    }

    private void performCompleteStyleAttr(LayoutElement node) {
        NamespaceCollection namespaces = this.getNamespaces();
        String[] namespaceNames = namespaces.getNamespaces();
        LayoutContext layoutContext = node.getLayoutContext();
        AttributeMap attributes = layoutContext.getAttributes();
        for (int i = 0; i < namespaceNames.length; ++i) {
            String namespace = namespaceNames[i];
            NamespaceDefinition ndef = namespaces.getDefinition(namespace);
            if (ndef == null) continue;
            String[] styleAttrs = ndef.getStyleAttribute(layoutContext.getTagName());
            for (int x = 0; x < styleAttrs.length; ++x) {
                String attr = styleAttrs[x];
                Object styleValue = attributes.getAttribute(namespace, attr);
                this.addStyleFromAttribute(node, styleValue);
            }
        }
    }

    private void addStyleFromAttribute(LayoutElement node, Object styleValue) {
        if (styleValue == null) {
            return;
        }
        if (styleValue instanceof String) {
            String styleText = (String)styleValue;
            try {
                LayoutProcess layoutProcess = this.getLayoutProcess();
                byte[] bytes = styleText.getBytes("UTF-8");
                ResourceKey baseKey = DocumentContextUtility.getBaseResource(layoutProcess.getDocumentContext());
                ResourceManager manager = layoutProcess.getResourceManager();
                ResourceKey key = manager.createKey((Object)bytes);
                Resource resource = manager.create(key, baseKey, class$org$jfree$layouting$input$style$StyleRule == null ? (class$org$jfree$layouting$input$style$StyleRule = DefaultStyleResolver.class$("org.jfree.layouting.input.style.StyleRule")) : class$org$jfree$layouting$input$style$StyleRule);
                CSSDeclarationRule rule = (CSSDeclarationRule)resource.getResource();
                if (rule != null) {
                    this.copyStyleInformation(node.getLayoutContext(), rule, node);
                }
            }
            catch (Exception e) {
                Log.debug((Object)"Unable to handle style attribute value.", (Exception)e);
            }
        } else if (styleValue instanceof CSSDeclarationRule) {
            CSSDeclarationRule rule = (CSSDeclarationRule)styleValue;
            this.copyStyleInformation(node.getLayoutContext(), rule, node);
        }
    }

    private void performSelectionStep(LayoutElement element, LayoutStyle style) {
        CSSStyleRule[] activeStyleRules = this.styleRuleMatcher.getMatchingRules(element);
        Arrays.sort(activeStyleRules, new CSSStyleRuleComparator());
        SelectorWeight oldSelectorWeight = null;
        for (int i = 0; i < activeStyleRules.length; ++i) {
            CSSStyleRule activeStyleRule = activeStyleRules[i];
            CSSSelector selector = activeStyleRule.getSelector();
            SelectorWeight activeWeight = selector.getWeight();
            if (oldSelectorWeight != null && oldSelectorWeight.compareTo(activeWeight) > 0) {
                oldSelectorWeight = activeWeight;
                continue;
            }
            oldSelectorWeight = activeWeight;
            this.copyStyleInformation(style, activeStyleRule, element);
        }
    }

    public StyleResolver deriveInstance() {
        return this;
    }

    public State saveState() throws StateException {
        DefaultStyleResolverState state = new DefaultStyleResolverState();
        this.fillState(state);
        state.setRuleMatcher(this.styleRuleMatcher);
        state.setStrictStyleMode(this.strictStyleMode);
        return state;
    }

    public LayoutStyle resolvePageStyle(CSSValue pageName, PseudoPage[] pseudoPages, PageAreaType pageArea) {
        LayoutStyleImpl style = new LayoutStyleImpl();
        CSSPageRule[] pageRule = this.styleRuleMatcher.getPageRule(pageName, pseudoPages);
        for (int i = 0; i < pageRule.length; ++i) {
            CSSPageRule cssPageRule = pageRule[i];
            this.copyStyleInformation(style, cssPageRule, null);
            int rc = cssPageRule.getRuleCount();
            for (int r = 0; r < rc; ++r) {
                CSSPageAreaRule rule = cssPageRule.getRule(r);
                if (!rule.getPageArea().equals(pageArea)) continue;
                this.copyStyleInformation(style, rule, null);
            }
        }
        return style;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class DefaultStyleResolverState
    extends AbstractStyleResolver.AbstractStyleResolverState {
        private boolean strictStyleMode;
        private StyleRuleMatcher ruleMatcher;

        private DefaultStyleResolverState() {
        }

        public boolean isStrictStyleMode() {
            return this.strictStyleMode;
        }

        public void setStrictStyleMode(boolean strictStyleMode) {
            this.strictStyleMode = strictStyleMode;
        }

        public StyleRuleMatcher getRuleMatcher() {
            return this.ruleMatcher;
        }

        public void setRuleMatcher(StyleRuleMatcher ruleMatcher) {
            this.ruleMatcher = ruleMatcher;
        }

        protected AbstractStyleResolver create() {
            return new DefaultStyleResolver();
        }

        protected void fill(AbstractStyleResolver resolver, LayoutProcess layoutProcess) {
            super.fill(resolver, layoutProcess);
            DefaultStyleResolver res = (DefaultStyleResolver)resolver;
            res.styleRuleMatcher = this.ruleMatcher;
            res.strictStyleMode = this.strictStyleMode;
        }
    }
}

