/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver;

import java.util.ArrayList;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.StatefullComponent;
import org.jfree.layouting.input.style.CSSDeclarationRule;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.StyleKeyRegistry;
import org.jfree.layouting.input.style.StyleRule;
import org.jfree.layouting.input.style.StyleSheet;
import org.jfree.layouting.input.style.keys.content.ContentStyleKeys;
import org.jfree.layouting.input.style.values.CSSAttrFunction;
import org.jfree.layouting.input.style.values.CSSFunctionValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValueList;
import org.jfree.layouting.input.style.values.CSSValuePair;
import org.jfree.layouting.layouter.context.ContextId;
import org.jfree.layouting.layouter.context.DefaultLayoutContext;
import org.jfree.layouting.layouter.context.DocumentContext;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.context.LayoutStyle;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.LayoutStyleImpl;
import org.jfree.layouting.layouter.style.functions.FunctionEvaluationException;
import org.jfree.layouting.layouter.style.functions.values.AttrValueFunction;
import org.jfree.layouting.layouter.style.resolver.StyleResolver;
import org.jfree.layouting.namespace.NamespaceCollection;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.resourceloader.Resource;
import org.jfree.resourceloader.ResourceManager;
import org.jfree.util.Log;

public abstract class AbstractStyleResolver
implements StyleResolver {
    private LayoutStyle initialStyle;
    private LayoutProcess layoutProcess;
    private DocumentContext documentContext;
    private NamespaceCollection namespaces;
    private StyleKey[] keys;
    private AttrValueFunction attrFunction;
    static /* synthetic */ Class class$org$jfree$layouting$input$style$StyleSheet;

    protected AbstractStyleResolver() {
    }

    public LayoutContext createAnonymousContext(ContextId id, LayoutContext parent) {
        LayoutElement parentElement = new LayoutElement(null, null, parent);
        DefaultLayoutContext anonymousContext = new DefaultLayoutContext(id, "http://jfreereport.sourceforge.net/namespaces/layout", "anonymous-context", null, new AttributeMap());
        LayoutElement anonymousElement = new LayoutElement(parentElement, null, anonymousContext);
        this.resolveOutOfContext(anonymousElement);
        return anonymousContext;
    }

    public void initialize(LayoutProcess layoutProcess) {
        this.layoutProcess = layoutProcess;
        this.documentContext = layoutProcess.getDocumentContext();
        this.namespaces = this.documentContext.getNamespaces();
        this.attrFunction = new AttrValueFunction();
    }

    protected void loadInitialStyle() {
        this.initialStyle = new LayoutStyleImpl();
        try {
            ResourceManager manager = this.layoutProcess.getResourceManager();
            Resource resource = manager.createDirectly((Object)"res://org/jfree/layouting/initial.css", class$org$jfree$layouting$input$style$StyleSheet == null ? (class$org$jfree$layouting$input$style$StyleSheet = AbstractStyleResolver.class$("org.jfree.layouting.input.style.StyleSheet")) : class$org$jfree$layouting$input$style$StyleSheet);
            StyleSheet initialStyleSheet = (StyleSheet)resource.getResource();
            int rc = initialStyleSheet.getRuleCount();
            for (int i = 0; i < rc; ++i) {
                StyleRule rule = initialStyleSheet.getRule(i);
                if (!(rule instanceof CSSDeclarationRule)) continue;
                CSSDeclarationRule drule = (CSSDeclarationRule)rule;
                this.copyStyleInformation(this.initialStyle, drule, null);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Initial-StyleSheet could not be parsed. This is a FATAL error.");
        }
        DocumentContext documentContext = this.layoutProcess.getDocumentContext();
        documentContext.setMetaAttribute("initial-style", this.initialStyle);
    }

    protected void copyStyleInformation(LayoutStyle target, CSSDeclarationRule rule, LayoutElement element) {
        try {
            StyleKey key;
            int i;
            StyleRule parentRule = rule.getParentRule();
            if (parentRule instanceof CSSDeclarationRule) {
                this.copyStyleInformation(target, (CSSDeclarationRule)parentRule, element);
            }
            if (element == null) {
                StyleKey[] propertyKeys = rule.getPropertyKeysAsArray();
                for (int i2 = 0; i2 < propertyKeys.length; ++i2) {
                    StyleKey key2 = propertyKeys[i2];
                    target.setValue(key2, rule.getPropertyCSSValue(key2));
                }
                return;
            }
            StyleKey[] propertyKeys = rule.getPropertyKeysAsArray();
            CSSValue[] values = new CSSValue[rule.getSize()];
            for (i = 0; i < values.length; ++i) {
                key = propertyKeys[i];
                CSSValue value = rule.getPropertyCSSValue(key);
                values[i] = ContentStyleKeys.CONTENT.equals(key) || ContentStyleKeys.STRING_DEFINE.equals(key) || ContentStyleKeys.STRING_SET.equals(key) ? value : this.resolveValue(value, element);
            }
            for (i = 0; i < values.length; ++i) {
                key = propertyKeys[i];
                target.setValue(key, values[i]);
            }
        }
        catch (FunctionEvaluationException e) {
            Log.debug((Object)"Skipping rule, as resolving failed.");
        }
    }

    protected CSSValue resolveValue(CSSValue value, LayoutElement element) throws FunctionEvaluationException {
        if (element == null) {
            return value;
        }
        if (value == null) {
            return null;
        }
        if (!this.containsAttrFunction(value)) {
            return value;
        }
        if (value instanceof CSSAttrFunction) {
            return this.attrFunction.evaluate(this.getLayoutProcess(), element, (CSSFunctionValue)value);
        }
        if (value instanceof CSSValueList) {
            CSSValueList list = (CSSValueList)value;
            ArrayList<CSSValue> retValus = new ArrayList<CSSValue>();
            int length = list.getLength();
            for (int i = 0; i < length; ++i) {
                CSSValue item = list.getItem(i);
                retValus.add(this.resolveValue(item, element));
            }
            return new CSSValueList(retValus);
        }
        if (value instanceof CSSValuePair) {
            CSSValuePair pair = (CSSValuePair)value;
            return new CSSValuePair(this.resolveValue(pair.getFirstValue(), element), this.resolveValue(pair.getSecondValue(), element));
        }
        return value;
    }

    protected boolean containsAttrFunction(CSSValue value) {
        if (value == null) {
            return false;
        }
        if (value instanceof CSSAttrFunction) {
            return true;
        }
        if (value instanceof CSSValueList) {
            CSSValueList list = (CSSValueList)value;
            int length = list.getLength();
            for (int i = 0; i < length; ++i) {
                CSSValue item = list.getItem(i);
                if (!this.containsAttrFunction(item)) continue;
                return true;
            }
            return false;
        }
        if (value instanceof CSSValuePair) {
            CSSValuePair pair = (CSSValuePair)value;
            if (this.containsAttrFunction(pair.getFirstValue())) {
                return true;
            }
            return this.containsAttrFunction(pair.getSecondValue());
        }
        return false;
    }

    protected LayoutProcess getLayoutProcess() {
        return this.layoutProcess;
    }

    public LayoutStyle getInitialStyle() {
        return this.initialStyle;
    }

    protected DocumentContext getDocumentContext() {
        return this.documentContext;
    }

    protected StyleKey[] getKeys() {
        if (this.keys == null) {
            this.keys = StyleKeyRegistry.getRegistry().getKeys(new StyleKey[0]);
        }
        return this.keys;
    }

    protected NamespaceCollection getNamespaces() {
        return this.namespaces;
    }

    protected void fillState(AbstractStyleResolverState state) {
        state.setInitialStyle(this.initialStyle);
        state.setKeys(this.keys);
    }

    protected abstract void resolveOutOfContext(LayoutElement var1);

    static /* synthetic */ StyleKey[] access$402(AbstractStyleResolver x0, StyleKey[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static abstract class AbstractStyleResolverState
    implements State {
        private LayoutStyle initialStyle;
        private StyleKey[] keys;

        protected AbstractStyleResolverState() {
        }

        public LayoutStyle getInitialStyle() {
            return this.initialStyle;
        }

        public void setInitialStyle(LayoutStyle initialStyle) {
            this.initialStyle = initialStyle;
        }

        protected abstract AbstractStyleResolver create();

        public StatefullComponent restore(LayoutProcess layoutProcess) throws StateException {
            AbstractStyleResolver resv = this.create();
            this.fill(resv, layoutProcess);
            return resv;
        }

        protected void fill(AbstractStyleResolver resolver, LayoutProcess layoutProcess) {
            resolver.initialStyle = this.initialStyle;
            resolver.layoutProcess = layoutProcess;
            resolver.documentContext = layoutProcess.getDocumentContext();
            resolver.namespaces = layoutProcess.getDocumentContext().getNamespaces();
            AbstractStyleResolver.access$402(resolver, this.keys);
            resolver.attrFunction = new AttrValueFunction();
        }

        public StyleKey[] getKeys() {
            return this.keys;
        }

        public void setKeys(StyleKey[] keys) {
            this.keys = keys;
        }
    }
}

