/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.functions.values;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.values.CSSColorValue;
import org.jfree.layouting.input.style.values.CSSFunctionValue;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSStringValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.functions.FunctionEvaluationException;
import org.jfree.layouting.layouter.style.functions.FunctionUtilities;
import org.jfree.layouting.layouter.style.functions.values.StyleValueFunction;
import org.jfree.layouting.util.ColorUtil;

public class HslValueFunction
implements StyleValueFunction {
    protected int validateHueParameter(CSSValue value) throws FunctionEvaluationException {
        CSSNumericValue nval;
        if (value instanceof CSSStringValue) {
            CSSStringValue strVal = (CSSStringValue)value;
            nval = FunctionUtilities.parseNumberValue(strVal.getValue());
        } else {
            if (!(value instanceof CSSNumericValue)) {
                throw new FunctionEvaluationException("Expected a number");
            }
            nval = (CSSNumericValue)value;
        }
        if (nval.getType().equals(CSSNumericType.NUMBER)) {
            return (int)(nval.getValue() % 360.0);
        }
        throw new FunctionEvaluationException("Expected a number, not a length");
    }

    protected float validateOtherParameter(CSSValue value) throws FunctionEvaluationException {
        CSSNumericValue nval;
        if (value instanceof CSSStringValue) {
            CSSStringValue strVal = (CSSStringValue)value;
            nval = FunctionUtilities.parseNumberValue(strVal.getValue());
        } else {
            if (!(value instanceof CSSNumericValue)) {
                throw new FunctionEvaluationException("Expected a number");
            }
            nval = (CSSNumericValue)value;
        }
        if (nval.getType().equals(CSSNumericType.PERCENTAGE)) {
            return (float)(nval.getValue() % 100.0);
        }
        throw new FunctionEvaluationException("Expected a number, not a length");
    }

    public CSSValue evaluate(LayoutProcess layoutProcess, LayoutElement element, CSSFunctionValue function) throws FunctionEvaluationException {
        CSSValue[] values = function.getParameters();
        if (values.length == 3) {
            int hueValue = this.validateHueParameter(FunctionUtilities.resolveParameter(layoutProcess, element, values[0]));
            float saturationValue = this.validateOtherParameter(FunctionUtilities.resolveParameter(layoutProcess, element, values[1]));
            float lightValue = this.validateOtherParameter(FunctionUtilities.resolveParameter(layoutProcess, element, values[2]));
            float[] rgb = ColorUtil.hslToRGB(hueValue, saturationValue, lightValue);
            return new CSSColorValue(rgb[0], rgb[1], rgb[2]);
        }
        if (values.length == 4) {
            int hueValue = this.validateHueParameter(FunctionUtilities.resolveParameter(layoutProcess, element, values[0]));
            float saturationValue = this.validateOtherParameter(FunctionUtilities.resolveParameter(layoutProcess, element, values[1]));
            float lightValue = this.validateOtherParameter(FunctionUtilities.resolveParameter(layoutProcess, element, values[2]));
            float alphaValue = this.validateOtherParameter(FunctionUtilities.resolveParameter(layoutProcess, element, values[3]));
            float[] rgb = ColorUtil.hslToRGB(hueValue, saturationValue, lightValue);
            return new CSSColorValue(rgb[0], rgb[1], rgb[2], alphaValue);
        }
        throw new FunctionEvaluationException("Expected either three or four parameters.");
    }
}

