/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.functions.values;

import java.awt.Color;
import java.net.URL;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.values.CSSColorValue;
import org.jfree.layouting.input.style.values.CSSFunctionValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.functions.FunctionEvaluationException;
import org.jfree.layouting.layouter.style.functions.FunctionUtilities;
import org.jfree.layouting.layouter.style.functions.values.StyleValueFunction;
import org.jfree.layouting.layouter.style.values.CSSRawValue;
import org.jfree.layouting.layouter.style.values.CSSResourceValue;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.layouting.util.ColorUtil;
import org.jfree.resourceloader.Resource;
import org.jfree.resourceloader.ResourceKey;

public class AttrValueFunction
implements StyleValueFunction {
    public CSSValue evaluate(LayoutProcess layoutProcess, LayoutElement element, CSSFunctionValue function) throws FunctionEvaluationException {
        CSSValue[] params = function.getParameters();
        if (params.length < 2) {
            throw new FunctionEvaluationException("The parsed attr() function needs at least two parameters.");
        }
        String namespace = FunctionUtilities.resolveString(layoutProcess, element, params[0]);
        String name = FunctionUtilities.resolveString(layoutProcess, element, params[1]);
        String type = null;
        if (params.length >= 3) {
            type = FunctionUtilities.resolveString(layoutProcess, element, params[2]);
        }
        AttributeMap attributes = element.getLayoutContext().getAttributes();
        if (namespace == null || "".equals(namespace)) {
            Object value = attributes.getAttribute(element.getLayoutContext().getNamespace(), name);
            return this.convertValue(layoutProcess, value, type);
        }
        if ("*".equals(namespace)) {
            Object value = attributes.getFirstAttribute(name);
            return this.convertValue(layoutProcess, value, type);
        }
        Object value = attributes.getAttribute(namespace, name);
        return this.convertValue(layoutProcess, value, type);
    }

    private CSSValue convertValue(LayoutProcess layoutProcess, Object value, String type) throws FunctionEvaluationException {
        if (value instanceof CSSValue) {
            throw new FunctionEvaluationException();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if ("length".equals(type)) {
                return FunctionUtilities.parseNumberValue(strVal);
            }
            if ("url".equals(type)) {
                return FunctionUtilities.loadResource(layoutProcess, strVal);
            }
            if ("color".equals(type)) {
                CSSValue colorValue = ColorUtil.parseColor(strVal);
                if (colorValue == null) {
                    throw new FunctionEvaluationException();
                }
                return colorValue;
            }
            return FunctionUtilities.parseValue(layoutProcess, strVal);
        }
        if (value instanceof URL) {
            return FunctionUtilities.loadResource(layoutProcess, value);
        }
        if (value instanceof Resource) {
            return new CSSResourceValue((Resource)value);
        }
        if (value instanceof ResourceKey) {
            return FunctionUtilities.loadResource(layoutProcess, value);
        }
        if (value instanceof Number) {
            return FunctionUtilities.parseNumberValue(value.toString(), type);
        }
        if (value instanceof Color) {
            Color color = (Color)value;
            return new CSSColorValue(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        }
        return new CSSRawValue(value);
    }
}

