/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.functions.content;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.values.CSSFunctionValue;
import org.jfree.layouting.input.style.values.CSSStringValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.content.ContentToken;
import org.jfree.layouting.layouter.content.statics.ResourceContentToken;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.functions.FunctionEvaluationException;
import org.jfree.layouting.layouter.style.functions.FunctionUtilities;
import org.jfree.layouting.layouter.style.functions.content.ContentFunction;
import org.jfree.layouting.layouter.style.values.CSSResourceValue;
import org.jfree.resourceloader.Resource;

public class UrlValueFunction
implements ContentFunction {
    public ContentToken evaluate(LayoutProcess layoutProcess, LayoutElement element, CSSFunctionValue function) throws FunctionEvaluationException {
        CSSValue[] params = function.getParameters();
        if (params.length != 1) {
            throw new FunctionEvaluationException();
        }
        CSSValue value = FunctionUtilities.resolveParameter(layoutProcess, element, params[0]);
        if (value instanceof CSSResourceValue) {
            CSSResourceValue cssResourceValue = (CSSResourceValue)value;
            Resource resource = cssResourceValue.getValue();
            return new ResourceContentToken(resource);
        }
        if (!(value instanceof CSSStringValue)) {
            throw new FunctionEvaluationException("Not even remotely an URI: " + value);
        }
        CSSStringValue strval = (CSSStringValue)value;
        CSSResourceValue cssResourceValue = FunctionUtilities.loadResource(layoutProcess, strval.getValue());
        Resource resource = cssResourceValue.getValue();
        return new ResourceContentToken(resource);
    }
}

