/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.functions.content;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.values.CSSFunctionValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.content.ContentToken;
import org.jfree.layouting.layouter.content.computed.CountersToken;
import org.jfree.layouting.layouter.context.DocumentContext;
import org.jfree.layouting.layouter.counters.CounterStyle;
import org.jfree.layouting.layouter.counters.CounterStyleFactory;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.functions.FunctionEvaluationException;
import org.jfree.layouting.layouter.style.functions.FunctionUtilities;
import org.jfree.layouting.layouter.style.functions.content.ContentFunction;

public class CountersValueFunction
implements ContentFunction {
    public ContentToken evaluate(LayoutProcess layoutProcess, LayoutElement element, CSSFunctionValue function) throws FunctionEvaluationException {
        CSSValue[] params = function.getParameters();
        if (params.length < 2) {
            throw new FunctionEvaluationException();
        }
        String counterName = FunctionUtilities.resolveString(layoutProcess, element, params[0]);
        String separator = FunctionUtilities.resolveString(layoutProcess, element, params[1]);
        CounterStyle cstyle = null;
        if (params.length > 2) {
            String styleName = FunctionUtilities.resolveString(layoutProcess, element, params[2]);
            cstyle = CounterStyleFactory.getInstance().getCounterStyle(styleName);
        }
        if (cstyle == null) {
            DocumentContext documentContext = layoutProcess.getDocumentContext();
            cstyle = documentContext.getCounterStyle(counterName);
        }
        return new CountersToken(counterName, separator, cstyle);
    }
}

