/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.functions.content;

import java.net.URL;
import java.util.Date;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.values.CSSFunctionValue;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSStringValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.content.ContentToken;
import org.jfree.layouting.layouter.content.statics.ExternalContentToken;
import org.jfree.layouting.layouter.content.statics.ResourceContentToken;
import org.jfree.layouting.layouter.content.statics.StaticTextToken;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.functions.FunctionEvaluationException;
import org.jfree.layouting.layouter.style.functions.FunctionUtilities;
import org.jfree.layouting.layouter.style.functions.content.ContentFunction;
import org.jfree.layouting.layouter.style.values.CSSResourceValue;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.layouting.util.ColorUtil;
import org.jfree.resourceloader.Resource;
import org.jfree.resourceloader.ResourceKey;

public class AttrValueFunction
implements ContentFunction {
    public ContentToken evaluate(LayoutProcess layoutProcess, LayoutElement element, CSSFunctionValue function) throws FunctionEvaluationException {
        CSSValue[] params = function.getParameters();
        if (params.length < 2) {
            throw new FunctionEvaluationException("The parsed attr() function needs at least two parameters.");
        }
        String namespace = FunctionUtilities.resolveString(layoutProcess, element, params[0]);
        String name = FunctionUtilities.resolveString(layoutProcess, element, params[1]);
        String type = null;
        if (params.length >= 3) {
            type = FunctionUtilities.resolveString(layoutProcess, element, params[2]);
        }
        AttributeMap attributes = element.getLayoutContext().getAttributes();
        if (namespace == null || "".equals(namespace)) {
            Object value = attributes.getAttribute(element.getLayoutContext().getNamespace(), name);
            return this.convertValue(layoutProcess, value, type);
        }
        if ("*".equals(namespace)) {
            Object value = attributes.getFirstAttribute(name);
            return this.convertValue(layoutProcess, value, type);
        }
        Object value = attributes.getAttribute(namespace, name);
        return this.convertValue(layoutProcess, value, type);
    }

    private ContentToken convertValue(LayoutProcess layoutProcess, Object value, String type) throws FunctionEvaluationException {
        if (value instanceof CSSValue) {
            throw new FunctionEvaluationException();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if ("length".equals(type)) {
                CSSNumericValue cssNumericValue = FunctionUtilities.parseNumberValue(strVal);
                return new StaticTextToken(cssNumericValue.getCSSText());
            }
            if ("url".equals(type)) {
                CSSResourceValue cssResourceValue = FunctionUtilities.loadResource(layoutProcess, strVal);
                Resource resource = cssResourceValue.getValue();
                return new ResourceContentToken(resource);
            }
            if ("color".equals(type)) {
                CSSValue colorValue = ColorUtil.parseColor(strVal);
                if (colorValue == null) {
                    throw new FunctionEvaluationException();
                }
                return new StaticTextToken(colorValue.getCSSText());
            }
            CSSValue cssValue = FunctionUtilities.parseValue(layoutProcess, strVal);
            if (cssValue instanceof CSSResourceValue) {
                CSSResourceValue cssResourceValue = (CSSResourceValue)cssValue;
                Resource resource = cssResourceValue.getValue();
                return new ResourceContentToken(resource);
            }
            if (cssValue instanceof CSSStringValue) {
                CSSStringValue sval = (CSSStringValue)cssValue;
                return new StaticTextToken(sval.getValue());
            }
            return new StaticTextToken(cssValue.getCSSText());
        }
        if (value instanceof URL) {
            CSSResourceValue cssResourceValue = FunctionUtilities.loadResource(layoutProcess, value);
            Resource resource = cssResourceValue.getValue();
            return new ResourceContentToken(resource);
        }
        if (value instanceof Resource) {
            return new ResourceContentToken((Resource)value);
        }
        if (value instanceof ResourceKey) {
            CSSResourceValue cssResourceValue = FunctionUtilities.loadResource(layoutProcess, value);
            Resource resource = cssResourceValue.getValue();
            return new ResourceContentToken(resource);
        }
        if (value instanceof Date) {
            return new StaticTextToken(String.valueOf(value));
        }
        if (value instanceof Number) {
            return new StaticTextToken(String.valueOf(value));
        }
        return new ExternalContentToken(value);
    }
}

