/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style;

import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.StyleKeyRegistry;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutStyle;

public final class LayoutStyleImpl
implements LayoutStyle {
    private CSSValue[] values;
    private Object reference;

    public Object getReference() {
        return this.reference;
    }

    public void setReference(Object reference) {
        this.reference = reference;
    }

    public synchronized CSSValue getValue(StyleKey key) {
        if (this.values == null) {
            return null;
        }
        return this.values[key.getIndex()];
    }

    public synchronized void setValue(StyleKey key, CSSValue value) {
        if (this.values == null) {
            this.values = new CSSValue[StyleKeyRegistry.getRegistry().getKeyCount()];
        }
        this.values[key.getIndex()] = value;
    }

    public synchronized void dispose() {
    }

    public synchronized LayoutStyleImpl createCopy() {
        LayoutStyleImpl style = new LayoutStyleImpl();
        if (this.values == null) {
            style.values = null;
            return style;
        }
        style.values = (CSSValue[])this.values.clone();
        return style;
    }

    public boolean isClean() {
        if (this.values == null) {
            return true;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == null) continue;
            return false;
        }
        return true;
    }

    public boolean copyFrom(LayoutStyle style) {
        if (!(style instanceof LayoutStyleImpl)) {
            return false;
        }
        LayoutStyleImpl rawstyle = (LayoutStyleImpl)style;
        if (rawstyle.values == null) {
            return true;
        }
        if (this.values == null) {
            this.values = (CSSValue[])rawstyle.values.clone();
            return true;
        }
        int length = rawstyle.values.length;
        for (int i = 0; i < length; ++i) {
            CSSValue o = rawstyle.values[i];
            if (o == null) continue;
            this.values[i] = o;
        }
        return true;
    }
}

