/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.feed;

import java.io.IOException;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.StatefullComponent;
import org.jfree.layouting.input.style.PseudoPage;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.DefaultDocumentMetaNode;
import org.jfree.layouting.layouter.context.DocumentContext;
import org.jfree.layouting.layouter.context.DocumentMetaNode;
import org.jfree.layouting.layouter.feed.InputFeed;
import org.jfree.layouting.layouter.feed.InputFeedException;
import org.jfree.layouting.namespace.NamespaceCollection;
import org.jfree.layouting.normalizer.content.NormalizationException;
import org.jfree.layouting.normalizer.content.Normalizer;
import org.jfree.layouting.util.AttributeMap;

public class DefaultInputFeed
implements InputFeed {
    public static final int DOCUMENT_STARTING = 0;
    public static final int META_EXPECTED = 1;
    public static final int META_PROCESSING = 2;
    public static final int META_NODE_START = 3;
    public static final int META_NODE_ATTRIBUTES = 4;
    public static final int ELEMENT_EXPECTED = 5;
    public static final int ELEMENT_STARTED = 6;
    public static final int ELEMENT_ATTRIBUTES = 7;
    public static final int ELEMENT_CONTENT = 8;
    public static final int DOCUMENT_FINISHED = 9;
    private static final String[] STATE_NAMES = new String[]{"DOCUMENT_STARTING", "META_EXPECTED", "META_PROCESSING", "META_NODE_START", "META_NODE_ATTRIBUTES", "ELEMENT_EXPECTED", "ELEMENT_STARTED", "ELEMENT_ATTRIBUTES", "ELEMENT_CONTENT", "DOCUMENT_FINISHED"};
    private static boolean[][] validStateTransitions = new boolean[10][];
    private boolean initialized;
    private int state;
    private LayoutProcess process;
    private DocumentMetaNode metaNode;
    private DocumentContext documentContext;
    private Normalizer normalizer;
    private boolean pagebreakEncountered;
    private int treeDepth;
    private AttributeMap currentAttributes;
    private String namespace;
    private String tagName;

    public DefaultInputFeed(LayoutProcess process) {
        this(process, true);
    }

    protected DefaultInputFeed(LayoutProcess process, boolean init) {
        this.process = process;
        this.documentContext = process.getDocumentContext();
        if (init) {
            this.normalizer = process.getOutputProcessor().createNormalizer(process);
            this.state = 0;
        }
    }

    public void resetPageBreakFlag() {
        this.pagebreakEncountered = false;
    }

    public void handlePageBreakEncountered(CSSValue pageName, PseudoPage[] pseudoPages) throws NormalizationException {
        this.pagebreakEncountered = true;
        this.normalizer.handlePageBreak(pageName, pseudoPages);
    }

    public boolean isPagebreakEncountered() {
        return this.pagebreakEncountered;
    }

    private int checkState(int newState) {
        if (!validStateTransitions[this.state][newState]) {
            throw new IllegalStateException("illegal transition from " + STATE_NAMES[this.state] + " to " + STATE_NAMES[newState]);
        }
        int oldState = this.state;
        this.state = newState;
        return oldState;
    }

    public final void startDocument() {
        this.checkState(1);
        this.performStartDocument();
    }

    protected void performStartDocument() {
    }

    public final void startMetaInfo() {
        this.checkState(2);
        this.performStartMetaInfo();
    }

    protected void performStartMetaInfo() {
    }

    public final void addDocumentAttribute(String name, Object attr) {
        this.checkState(2);
        this.performAddDocumentAttribute(name, attr);
    }

    protected void performAddDocumentAttribute(String name, Object attr) {
        this.documentContext.setMetaAttribute(name, attr);
    }

    public void startMetaNode() {
        this.checkState(3);
        this.performStartMetaNode();
    }

    protected void performStartMetaNode() {
        this.metaNode = new DefaultDocumentMetaNode();
        this.documentContext.addMetaNode(this.metaNode);
    }

    public final void setMetaNodeAttribute(String name, Object attr) {
        this.checkState(4);
        this.performSetMetaNodeAttribute(name, attr);
    }

    protected void performSetMetaNodeAttribute(String name, Object attr) {
        this.metaNode.setMetaAttribute(name, attr);
    }

    public void endMetaNode() {
        this.checkState(2);
        this.performEndMetaNode();
    }

    protected void performEndMetaNode() {
        this.metaNode = null;
    }

    public final void endMetaInfo() throws InputFeedException {
        this.checkState(5);
        this.performEndMetaInfo();
    }

    public NamespaceCollection getNamespaceCollection() {
        if (!this.initialized) {
            throw new IllegalStateException("Not yet!");
        }
        return this.documentContext.getNamespaces();
    }

    protected void performEndMetaInfo() throws InputFeedException {
        try {
            this.initializeDocument();
        }
        catch (Exception e) {
            throw new InputFeedException("Failed to normalize element", e);
        }
    }

    public final void startElement(String namespace, String name) throws InputFeedException {
        int oldState = this.checkState(6);
        if (oldState == 1 || oldState == 5) {
            try {
                this.initializeDocument();
            }
            catch (Exception e) {
                throw new InputFeedException("Failed to normalize element", e);
            }
        }
        if (oldState == 7 || oldState == 6) {
            try {
                this.getNormalizer().startElement(this.namespace, this.tagName, this.currentAttributes);
                this.currentAttributes = null;
            }
            catch (NormalizationException e) {
                throw new InputFeedException("Failed to normalize element", (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new InputFeedException("IOError: Failed to normalize element", e);
            }
        }
        this.performStartElement(namespace, name);
    }

    private void initializeDocument() throws IOException, NormalizationException {
        if (this.initialized) {
            return;
        }
        this.documentContext.initialize();
        this.getNormalizer().startDocument();
        this.initialized = true;
    }

    protected void performStartElement(String namespace, String name) {
        this.namespace = namespace;
        this.tagName = name;
        this.currentAttributes = new AttributeMap();
    }

    public final void setAttribute(String namespace, String name, Object attr) {
        this.checkState(7);
        this.performSetAttribute(namespace, name, attr);
    }

    protected void performSetAttribute(String namespace, String name, Object attr) {
        this.currentAttributes.setAttribute(namespace, name, attr);
    }

    public final void addContent(String text) throws InputFeedException {
        try {
            int oldState = this.checkState(8);
            if (oldState == 7 || oldState == 6) {
                this.getNormalizer().startElement(this.namespace, this.tagName, this.currentAttributes);
                this.currentAttributes = null;
            } else if (oldState == 5 || oldState == 1) {
                this.initializeDocument();
            }
            this.performAddContent(text);
        }
        catch (NormalizationException ne) {
            throw new InputFeedException("Failed to normalize element", (Exception)((Object)ne));
        }
        catch (IOException ioe) {
            throw new InputFeedException("Failed to normalize element", ioe);
        }
    }

    protected void performAddContent(String text) throws InputFeedException, IOException, NormalizationException {
        this.getNormalizer().addText(text);
    }

    public final void endElement() throws InputFeedException {
        try {
            int oldState = this.checkState(5);
            if (oldState == 7 || oldState == 6) {
                this.getNormalizer().startElement(this.namespace, this.tagName, this.currentAttributes);
                this.currentAttributes = null;
            }
            this.performEndElement();
        }
        catch (NormalizationException e) {
            throw new InputFeedException("Failed to normalize element", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new InputFeedException("Failed to normalize element", e);
        }
    }

    protected void performEndElement() throws IOException, NormalizationException {
        this.namespace = null;
        this.tagName = null;
        this.currentAttributes = null;
        this.getNormalizer().endElement();
    }

    public final void endDocument() throws InputFeedException {
        this.checkState(9);
        try {
            this.performEndDocument();
        }
        catch (NormalizationException e) {
            throw new InputFeedException("Failed to normalize element", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new InputFeedException("Failed to normalize element", e);
        }
    }

    protected void performEndDocument() throws IOException, NormalizationException {
        this.getNormalizer().endDocument();
    }

    protected LayoutProcess getProcess() {
        return this.process;
    }

    protected int getState() {
        return this.state;
    }

    public Normalizer getNormalizer() {
        return this.normalizer;
    }

    public State saveState() throws StateException {
        DefaultInputFeedState state = new DefaultInputFeedState();
        state.setTreeDepth(this.treeDepth);
        state.setCurrentAttributes(this.currentAttributes);
        state.setNamespace(this.namespace);
        state.setTagName(this.tagName);
        state.setInitialized(this.initialized);
        state.setMetaNode(this.metaNode);
        state.setNormalizerState(this.normalizer.saveState());
        state.setState(this.state);
        state.setPagebreakEncountered(this.pagebreakEncountered);
        return state;
    }

    public Normalizer getCurrentNormalizer() {
        return this.normalizer;
    }

    static {
        DefaultInputFeed.validStateTransitions[0] = new boolean[]{false, true, false, false, false, false, false, false, false, false, false};
        DefaultInputFeed.validStateTransitions[1] = new boolean[]{false, false, true, false, false, false, true, false, false, false};
        DefaultInputFeed.validStateTransitions[2] = new boolean[]{false, false, true, true, false, true, false, false, false, false, false};
        DefaultInputFeed.validStateTransitions[3] = new boolean[]{false, false, false, false, true, false, false, false, false, false};
        DefaultInputFeed.validStateTransitions[4] = new boolean[]{false, false, true, false, true, false, false, false, false, false};
        DefaultInputFeed.validStateTransitions[5] = new boolean[]{false, false, false, false, false, true, true, false, true, true};
        DefaultInputFeed.validStateTransitions[6] = new boolean[]{false, false, false, false, false, true, true, true, true, true};
        DefaultInputFeed.validStateTransitions[7] = new boolean[]{false, false, false, false, false, true, true, true, true, true};
        DefaultInputFeed.validStateTransitions[8] = new boolean[]{false, false, false, false, false, true, true, false, true, true};
        DefaultInputFeed.validStateTransitions[9] = new boolean[]{false, false, false, false, false, false, false, false, false, false};
    }

    private static class DefaultInputFeedState
    implements State {
        private boolean initialized;
        private int state;
        private DocumentMetaNode metaNode;
        private State normalizerState;
        private boolean pagebreakEncountered;
        private int treeDepth;
        private AttributeMap currentAttributes;
        private String namespace;
        private String tagName;

        private DefaultInputFeedState() {
        }

        public int getTreeDepth() {
            return this.treeDepth;
        }

        public void setTreeDepth(int treeDepth) {
            this.treeDepth = treeDepth;
        }

        public AttributeMap getCurrentAttributes() {
            return this.currentAttributes;
        }

        public void setCurrentAttributes(AttributeMap currentAttributes) {
            this.currentAttributes = currentAttributes;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public String getTagName() {
            return this.tagName;
        }

        public void setTagName(String tagName) {
            this.tagName = tagName;
        }

        public boolean isPagebreakEncountered() {
            return this.pagebreakEncountered;
        }

        public void setPagebreakEncountered(boolean pagebreakEncountered) {
            this.pagebreakEncountered = pagebreakEncountered;
        }

        public boolean isInitialized() {
            return this.initialized;
        }

        public void setInitialized(boolean initialized) {
            this.initialized = initialized;
        }

        public int getState() {
            return this.state;
        }

        public void setState(int state) {
            this.state = state;
        }

        public DocumentMetaNode getMetaNode() {
            return this.metaNode;
        }

        public void setMetaNode(DocumentMetaNode metaNode) {
            this.metaNode = metaNode;
        }

        public State getNormalizerState() {
            return this.normalizerState;
        }

        public void setNormalizerState(State normalizerState) {
            this.normalizerState = normalizerState;
        }

        public StatefullComponent restore(LayoutProcess layoutProcess) throws StateException {
            DefaultInputFeed inputFeed = new DefaultInputFeed(layoutProcess, false);
            inputFeed.initialized = this.initialized;
            inputFeed.state = this.state;
            inputFeed.metaNode = this.metaNode;
            inputFeed.normalizer = (Normalizer)this.normalizerState.restore(layoutProcess);
            inputFeed.pagebreakEncountered = this.pagebreakEncountered;
            inputFeed.treeDepth = this.treeDepth;
            inputFeed.currentAttributes = this.currentAttributes;
            inputFeed.namespace = this.namespace;
            inputFeed.tagName = this.tagName;
            return inputFeed;
        }
    }
}

