/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.counters.numeric;

import java.util.HashSet;
import org.jfree.layouting.layouter.counters.CounterStyle;

public abstract class NumericCounterStyle
implements CounterStyle {
    private HashSet replacements;
    private int base;
    private transient ReplacementDefinition[] cachedDefinitions;
    private String suffix;

    protected NumericCounterStyle(int base, String suffix) {
        this.base = base;
        this.suffix = suffix;
        this.replacements = new HashSet();
    }

    public final void setReplacementChar(char org, char other) {
        this.replacements.add(new ReplacementDefinition(org, other));
        this.cachedDefinitions = null;
    }

    public final String getCounterValue(int index) {
        if (this.cachedDefinitions == null) {
            this.cachedDefinitions = this.replacements.toArray(new ReplacementDefinition[this.replacements.size()]);
        }
        String numeric = Integer.toString(index, this.base);
        for (int i = 0; i < this.cachedDefinitions.length; ++i) {
            ReplacementDefinition def = this.cachedDefinitions[i];
            numeric = numeric.replace(def.getOriginal(), def.getReplacement());
        }
        return numeric;
    }

    public String getSuffix() {
        return this.suffix;
    }

    private static final class ReplacementDefinition {
        private char original;
        private char replacement;

        private ReplacementDefinition(char original, char replacement) {
            this.original = original;
            this.replacement = replacement;
        }

        public char getOriginal() {
            return this.original;
        }

        public char getReplacement() {
            return this.replacement;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReplacementDefinition that = (ReplacementDefinition)o;
            return this.original == that.original;
        }

        public int hashCode() {
            return this.original;
        }
    }
}

