/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.context;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.BackgroundSpecification;
import org.jfree.layouting.layouter.context.ContentSpecification;
import org.jfree.layouting.layouter.context.ContextId;
import org.jfree.layouting.layouter.context.FontSpecification;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.context.LayoutStyle;
import org.jfree.layouting.layouter.context.ListSpecification;
import org.jfree.layouting.layouter.style.LayoutStyleImpl;
import org.jfree.layouting.util.AttributeMap;

public class DefaultLayoutContext
implements LayoutContext,
Cloneable {
    private static Map EMPTY_MAP = Collections.unmodifiableMap(new HashMap());
    private BackgroundSpecification backgroundSpecification;
    private FontSpecification fontSpecification;
    private ContentSpecification contentSpecification;
    private ListSpecification listSpecification;
    private LayoutStyleImpl style;
    private ContextId contextId;
    private String namespace;
    private String tagName;
    private AttributeMap attributeMap;
    private String pseudoElement;
    private boolean derived;
    private Map counters;
    private Map strings;

    public DefaultLayoutContext(ContextId contextId, String namespace, String tagName, String pseudoElement, AttributeMap attributeMap) {
        this.pseudoElement = pseudoElement;
        if (contextId == null) {
            throw new NullPointerException();
        }
        if (attributeMap == null) {
            throw new NullPointerException();
        }
        this.namespace = namespace;
        this.tagName = tagName;
        this.attributeMap = attributeMap;
        this.contextId = contextId;
        this.style = new LayoutStyleImpl();
        this.fontSpecification = new FontSpecification(this.style);
        this.backgroundSpecification = new BackgroundSpecification();
        this.contentSpecification = new ContentSpecification();
        this.listSpecification = new ListSpecification();
        this.strings = EMPTY_MAP;
        this.counters = EMPTY_MAP;
    }

    public String getPseudoElement() {
        return this.pseudoElement;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getTagName() {
        return this.tagName;
    }

    public AttributeMap getAttributes() {
        return this.attributeMap;
    }

    public BackgroundSpecification getBackgroundSpecification() {
        return this.backgroundSpecification;
    }

    public FontSpecification getFontSpecification() {
        return this.fontSpecification;
    }

    public ContentSpecification getContentSpecification() {
        return this.contentSpecification;
    }

    public ListSpecification getListSpecification() {
        return this.listSpecification;
    }

    public void setValue(StyleKey key, CSSValue value) {
        if (this.derived) {
            throw new IllegalStateException();
        }
        this.style.setValue(key, value);
    }

    public CSSValue getValue(StyleKey key) {
        return this.style.getValue(key);
    }

    public LayoutStyle getStyle() {
        return this.style;
    }

    public ContextId getContextId() {
        return this.contextId;
    }

    public Locale getLanguage() {
        return Locale.getDefault();
    }

    public boolean isPseudoElement() {
        return this.pseudoElement != null;
    }

    public Object clone() {
        try {
            DefaultLayoutContext lc = (DefaultLayoutContext)super.clone();
            lc.derived = true;
            return lc;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Invalid implementation: Clone not supported.");
        }
    }

    public LayoutContext derive() {
        DefaultLayoutContext lc = (DefaultLayoutContext)this.clone();
        lc.tagName = this.tagName + '*';
        return lc;
    }

    public void dispose() {
        this.style.dispose();
    }

    public boolean copyFrom(LayoutStyle style) {
        if (this.derived) {
            throw new IllegalStateException();
        }
        return this.style.copyFrom(style);
    }

    public Map getCounters() {
        return this.counters;
    }

    public Map getStrings() {
        return this.strings;
    }

    public LayoutContext detach(Map counters, Map strings) {
        DefaultLayoutContext dlc = (DefaultLayoutContext)this.derive();
        if (strings != null) {
            dlc.strings = Collections.unmodifiableMap(strings);
        }
        if (counters != null) {
            dlc.counters = Collections.unmodifiableMap(counters);
        }
        return dlc;
    }
}

