/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.context;

import java.util.HashMap;
import org.jfree.layouting.layouter.context.ElementContext;

public class DefaultElementContext
implements ElementContext {
    private HashMap strings;
    private HashMap counters;
    private ElementContext parentContext;

    public DefaultElementContext(ElementContext parentContext) {
        this.parentContext = parentContext;
    }

    public int getCounterValue(String counterName) {
        Integer counterValue;
        if (this.counters != null && (counterValue = (Integer)this.counters.get(counterName)) != null) {
            return counterValue;
        }
        if (this.parentContext != null) {
            return this.parentContext.getCounterValue(counterName);
        }
        return 0;
    }

    public void incrementCounter(String name, int value) {
        if (this.counters != null && this.counters.containsKey(name)) {
            int oldValue = this.getCounterValue(name);
            this.counters.put(name, new Integer(oldValue + value));
            return;
        }
        if (this.parentContext != null) {
            this.parentContext.incrementCounter(name, value);
            return;
        }
        int oldValue = this.getCounterValue(name);
        if (this.counters == null) {
            this.counters = new HashMap();
        }
        this.counters.put(name, new Integer(oldValue + value));
    }

    public void resetCounter(String name, int value) {
        if (this.counters == null) {
            this.counters = new HashMap();
        }
        this.counters.put(name, new Integer(value));
    }

    public boolean isCounterDefined(String counterName) {
        if (this.counters == null) {
            return false;
        }
        return this.counters.containsKey(counterName);
    }

    public void setString(String name, String value, boolean define) {
        if (!define && this.parentContext != null) {
            this.parentContext.setString(name, value, define);
            return;
        }
        if (value == null) {
            if (this.strings != null) {
                this.strings.remove(name);
            }
        } else {
            if (this.strings == null) {
                this.strings = new HashMap();
            }
            this.strings.put(name, value);
        }
    }

    public String getString(String name) {
        String value;
        if (this.strings != null && (value = (String)this.strings.get(name)) != null) {
            return value;
        }
        if (this.parentContext != null) {
            return this.parentContext.getString(name);
        }
        return null;
    }
}

