/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.context;

import org.jfree.layouting.layouter.content.ContentToken;
import org.jfree.layouting.layouter.content.computed.ContentsToken;
import org.jfree.layouting.layouter.context.QuotesPair;

public class ContentSpecification {
    private static final QuotesPair[] EMPTY_QUOTES = new QuotesPair[0];
    private static final ContentsToken[] EMPTY_CONTENT = new ContentsToken[0];
    private QuotesPair[] quotes = EMPTY_QUOTES;
    private ContentToken[] contents = EMPTY_CONTENT;
    private ContentToken[] strings = EMPTY_CONTENT;
    private ContentToken[] alternateText = EMPTY_CONTENT;
    private boolean allowContentProcessing = true;
    private boolean inhibitContent;
    private int quotingLevel;
    private String moveTarget;

    public boolean isInhibitContent() {
        return this.inhibitContent;
    }

    public void setInhibitContent(boolean inhibitContent) {
        this.inhibitContent = inhibitContent;
    }

    public QuotesPair[] getQuotes() {
        return (QuotesPair[])this.quotes.clone();
    }

    public ContentToken[] getStrings() {
        return (ContentToken[])this.strings.clone();
    }

    public void setStrings(ContentToken[] strings) {
        this.strings = (ContentToken[])strings.clone();
    }

    public ContentToken[] getAlternateText() {
        return (ContentToken[])this.alternateText.clone();
    }

    public void setAlternateText(ContentToken[] strings) {
        this.alternateText = (ContentToken[])strings.clone();
    }

    public String getOpenQuote(int level) {
        if (level < 0) {
            return "";
        }
        if (level >= this.quotes.length) {
            if (this.quotes.length == 0) {
                return "";
            }
            return this.quotes[this.quotes.length - 1].getOpenQuote();
        }
        return this.quotes[level].getOpenQuote();
    }

    public String getCloseQuote(int level) {
        if (level < 0) {
            return "";
        }
        if (level >= this.quotes.length) {
            if (this.quotes.length == 0) {
                return "";
            }
            return this.quotes[this.quotes.length - 1].getCloseQuote();
        }
        return this.quotes[level].getCloseQuote();
    }

    public void setQuotes(QuotesPair[] quotes) {
        if (this.quotes == null) {
            throw new NullPointerException();
        }
        this.quotes = (QuotesPair[])quotes.clone();
    }

    public ContentToken[] getContents() {
        return (ContentToken[])this.contents.clone();
    }

    public void setContents(ContentToken[] contents) {
        this.contents = (ContentToken[])contents.clone();
    }

    public boolean isAllowContentProcessing() {
        return this.allowContentProcessing;
    }

    public void setAllowContentProcessing(boolean allowContentProcessing) {
        this.allowContentProcessing = allowContentProcessing;
    }

    public int getQuotingLevel() {
        return this.quotingLevel;
    }

    public void setQuotingLevel(int quotingLevel) {
        this.quotingLevel = quotingLevel;
    }

    public String getMoveTarget() {
        return this.moveTarget;
    }

    public void setMoveTarget(String moveTarget) {
        this.moveTarget = moveTarget;
    }
}

