/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.content.resolved;

import org.jfree.layouting.layouter.content.computed.CountersToken;
import org.jfree.layouting.layouter.content.resolved.ResolvedToken;
import org.jfree.layouting.layouter.content.type.TextType;
import org.jfree.layouting.layouter.counters.CounterStyle;

public class ResolvedCountersToken
implements ResolvedToken,
TextType {
    private CountersToken parent;
    private int[] counterValues;

    public ResolvedCountersToken(CountersToken parent, int[] counterValues) {
        this.parent = parent;
        this.counterValues = counterValues;
    }

    public CountersToken getParent() {
        return this.parent;
    }

    public String getText() {
        CountersToken counterToken = this.getParent();
        CounterStyle style = counterToken.getStyle();
        String separator = counterToken.getSeparator();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.counterValues.length; ++i) {
            if (i != 0) {
                buffer.append(separator);
            }
            int value = this.counterValues[i];
            buffer.append(style.getCounterValue(value));
        }
        return buffer.toString();
    }

    public int[] getCounterValue() {
        return (int[])this.counterValues.clone();
    }
}

