/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.xhtml;

import java.io.IOException;
import java.net.URL;
import org.jfree.layouting.DefaultLayoutProcess;
import org.jfree.layouting.LibLayoutBoot;
import org.jfree.layouting.input.xhtml.XhtmlResourceFactoryModule;
import org.jfree.layouting.layouter.feed.InputFeed;
import org.jfree.layouting.layouter.feed.InputFeedException;
import org.jfree.layouting.modules.output.html.StreamingHtmlOutputProcessor;
import org.jfree.layouting.normalizer.content.NormalizationException;
import org.jfree.layouting.util.NullOutputStream;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XhtmlInputDriver {
    public static final String NAMESPACE = "http://www.w3.org/1999/xhtml";
    private InputFeed feed;

    public XhtmlInputDriver(InputFeed feed) {
        this.feed = feed;
    }

    public void processDomTree(Document doc) throws InputFeedException {
        Element rootElement = doc.getDocumentElement();
        if ("html".equalsIgnoreCase(rootElement.getTagName())) {
            this.processFullDocument(rootElement);
        } else {
            this.feed.startDocument();
            this.processBodyElement(rootElement);
            this.feed.endDocument();
        }
    }

    private void processFullDocument(Element rootElement) throws InputFeedException {
        this.feed.startDocument();
        this.feed.startMetaInfo();
        NodeList headList = rootElement.getElementsByTagName("head");
        for (int i = 0; i < headList.getLength(); ++i) {
            Element headerElement = (Element)headList.item(i);
            NodeList titles = headerElement.getElementsByTagName("title");
            for (int t = 0; t < titles.getLength(); ++t) {
                Element title = (Element)titles.item(t);
                this.feed.addDocumentAttribute("title", this.getCData(title));
            }
            NodeList metas = headerElement.getChildNodes();
            for (int t = 0; t < metas.getLength(); ++t) {
                Element meta;
                Node n = metas.item(t);
                if (!(n instanceof Element) || "title".equalsIgnoreCase((meta = (Element)metas.item(t)).getTagName())) continue;
                this.feed.startMetaNode();
                this.feed.setMetaNodeAttribute("type", meta.getTagName());
                NamedNodeMap nnm = meta.getAttributes();
                for (int ac = 0; ac < nnm.getLength(); ++ac) {
                    Attr attr = (Attr)nnm.item(ac);
                    this.feed.setMetaNodeAttribute(attr.getName(), attr.getValue());
                }
                this.feed.setMetaNodeAttribute("#pcdata", this.getCData(meta));
                this.feed.endMetaNode();
            }
        }
        this.feed.endMetaInfo();
        this.processBodyElement(rootElement);
        this.feed.endDocument();
    }

    private String getCData(Element element) {
        StringBuffer buffer = new StringBuffer();
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Text)) continue;
            Text text = (Text)n;
            buffer.append(text.getData());
        }
        return buffer.toString();
    }

    private void processBodyElement(Element element) throws InputFeedException {
        this.feed.startElement(NAMESPACE, element.getTagName());
        NamedNodeMap nnm = element.getAttributes();
        for (int ac = 0; ac < nnm.getLength(); ++ac) {
            Attr attr = (Attr)nnm.item(ac);
            this.feed.setAttribute(NAMESPACE, attr.getName(), attr.getValue());
        }
        NodeList childs = element.getChildNodes();
        for (int t = 0; t < childs.getLength(); ++t) {
            Node n = childs.item(t);
            if (n instanceof Element) {
                Element childElement = (Element)n;
                this.processBodyElement(childElement);
                continue;
            }
            if (!(n instanceof Text)) continue;
            Text tx = (Text)n;
            this.feed.addContent(tx.getData());
        }
        this.feed.endElement();
    }

    public static void main(String[] args) throws IOException, NormalizationException {
        LibLayoutBoot.getInstance().start();
        NullOutputStream out = new NullOutputStream();
        URL url = new URL("file:///home/src/jfreereport/head/liblayout/styletest/simple.html");
        XhtmlResourceFactoryModule module = new XhtmlResourceFactoryModule();
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < 10; ++i) {
            DefaultLayoutProcess process = new DefaultLayoutProcess(new StreamingHtmlOutputProcessor(LibLayoutBoot.getInstance().getGlobalConfig()));
            XhtmlInputDriver idrDriver = new XhtmlInputDriver(process.getInputFeed());
        }
        long endTime = System.currentTimeMillis();
        System.out.println("Done!: " + (endTime - startTime));
    }
}

