/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.swing.converter;

import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import org.jfree.layouting.input.style.keys.box.BoxStyleKeys;
import org.jfree.layouting.input.style.keys.line.LineStyleKeys;
import org.jfree.layouting.input.style.keys.text.TextAlign;
import org.jfree.layouting.input.style.keys.text.TextStyleKeys;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.swing.Converter;
import org.jfree.layouting.input.swing.ConverterAttributeSet;
import org.jfree.util.Log;

public class ParagraphConverter
implements Converter {
    public ConverterAttributeSet convertToCSS(Object key, Object value, ConverterAttributeSet cssAttr, Element context) {
        if (key instanceof StyleConstants.ParagraphConstants) {
            StyleConstants.ParagraphConstants paragraphConstant = (StyleConstants.ParagraphConstants)key;
            return this.handleParagraphConstants(paragraphConstant, value);
        }
        return null;
    }

    private ConverterAttributeSet handleParagraphConstants(StyleConstants.ParagraphConstants paragraphConstant, Object value) {
        ConverterAttributeSet attr = new ConverterAttributeSet();
        if (paragraphConstant == StyleConstants.FirstLineIndent) {
            CSSNumericValue cssNumericValue = CSSNumericValue.createValue(CSSNumericType.PT, Double.parseDouble(value.toString()));
            attr.addAttribute(TextStyleKeys.TEXT_INDENT.getName(), cssNumericValue);
        } else if (paragraphConstant == StyleConstants.RightIndent) {
            CSSNumericValue cssNumericValue = CSSNumericValue.createValue(CSSNumericType.PT, Double.parseDouble(value.toString()));
            attr.addAttribute(BoxStyleKeys.MARGIN_RIGHT.getName(), cssNumericValue);
        } else if (paragraphConstant == StyleConstants.LeftIndent) {
            CSSNumericValue cssNumericValue = CSSNumericValue.createValue(CSSNumericType.PT, Double.parseDouble(value.toString()));
            attr.addAttribute(BoxStyleKeys.MARGIN_LEFT.getName(), cssNumericValue);
        } else if (paragraphConstant == StyleConstants.LineSpacing) {
            CSSNumericValue cssNumericValue = CSSNumericValue.createValue(CSSNumericType.EM, Double.parseDouble(value.toString()));
            attr.addAttribute(LineStyleKeys.LINE_HEIGHT, cssNumericValue);
        } else if (paragraphConstant == StyleConstants.SpaceAbove) {
            CSSNumericValue cssNumericValue = CSSNumericValue.createValue(CSSNumericType.PT, Double.parseDouble(value.toString()));
            attr.addAttribute(BoxStyleKeys.MARGIN_TOP.getName(), cssNumericValue);
        } else if (paragraphConstant == StyleConstants.SpaceBelow) {
            CSSNumericValue cssNumericValue = CSSNumericValue.createValue(CSSNumericType.PT, Double.parseDouble(value.toString()));
            attr.addAttribute(BoxStyleKeys.MARGIN_BOTTOM.getName(), cssNumericValue);
        } else if (paragraphConstant == StyleConstants.Alignment) {
            CSSConstant val = null;
            int interger = Integer.parseInt(value.toString());
            if (interger == 1) {
                val = TextAlign.CENTER;
            } else if (interger == 3) {
                val = TextAlign.JUSTIFY;
            } else if (interger == 0) {
                val = TextAlign.LEFT;
            } else if (interger == 2) {
                val = TextAlign.RIGHT;
            }
            attr.addAttribute(TextStyleKeys.TEXT_ALIGN.getName(), val);
        } else {
            Log.debug((Object)new Log.SimpleMessage("Unkown type of paragraphe attribute", (Object)paragraphConstant));
            return null;
        }
        return attr;
    }
}

