/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.swing.converter;

import javax.swing.text.Element;
import org.jfree.layouting.input.style.keys.box.BoxStyleKeys;
import org.jfree.layouting.input.style.keys.page.PageSize;
import org.jfree.layouting.input.style.keys.page.PageStyleKeys;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.swing.Converter;
import org.jfree.layouting.input.swing.ConverterAttributeSet;
import org.jfree.util.Log;

public class DocumentConverter
implements Converter {
    public static final String PAGE_RULE_TYPE = "@page";
    public static final String RTF_PAGEWIDTH = "paperw";
    public static final String RTF_PAGEHEIGHT = "paperh";
    public static final String RTF_MARGINLEFT = "margl";
    public static final String RTF_MARGINRIGHT = "margr";
    public static final String RTF_MARGINTOP = "margt";
    public static final String RTF_MARGINBOTTOM = "margb";
    public static final String RTF_GUTTERWIDTH = "gutter";
    public static final String RTF_LANDSCAPE = "landscape";

    public ConverterAttributeSet convertToCSS(Object key, Object value, ConverterAttributeSet cssAttr, Element context) {
        if (key instanceof String) {
            return this.handleStringAttributes(key, value, cssAttr);
        }
        return null;
    }

    private ConverterAttributeSet handleStringAttributes(Object key, Object value, ConverterAttributeSet cssAttr) {
        ConverterAttributeSet attr = new ConverterAttributeSet();
        String styleKey = (String)key;
        if (styleKey.equals(RTF_PAGEWIDTH) || styleKey.equals(RTF_PAGEHEIGHT)) {
            float floatValue = ((Float)value).floatValue();
            Object size = cssAttr.getAttribute(PageStyleKeys.SIZE.getName());
            double width = 0.0;
            double height = 0.0;
            if (size instanceof PageSize) {
                PageSize pageSize = (PageSize)size;
                width = pageSize.getWidth();
                height = pageSize.getHeight();
            } else if (RTF_LANDSCAPE.equals(size)) {
                if (styleKey.equals(RTF_PAGEWIDTH)) {
                    height = this.twipToInt(floatValue);
                } else {
                    width = this.twipToInt(floatValue);
                }
            } else if (styleKey.equals(RTF_PAGEWIDTH)) {
                width = this.twipToInt(floatValue);
            } else {
                height = this.twipToInt(floatValue);
            }
            attr.addAttribute(PAGE_RULE_TYPE, PageStyleKeys.SIZE.getName(), new PageSize(width, height));
        } else if (styleKey.equals(RTF_MARGINLEFT)) {
            float floatValue = ((Float)value).floatValue();
            attr.addAttribute(PAGE_RULE_TYPE, BoxStyleKeys.MARGIN_LEFT.getName(), CSSNumericValue.createValue(CSSNumericType.PT, floatValue));
        } else if (styleKey.equals(RTF_MARGINRIGHT)) {
            float floatValue = ((Float)value).floatValue();
            attr.addAttribute(PAGE_RULE_TYPE, BoxStyleKeys.MARGIN_RIGHT.getName(), CSSNumericValue.createValue(CSSNumericType.PT, floatValue));
        } else if (styleKey.equals(RTF_MARGINTOP)) {
            float floatValue = ((Float)value).floatValue();
            attr.addAttribute(PAGE_RULE_TYPE, BoxStyleKeys.MARGIN_TOP.getName(), CSSNumericValue.createValue(CSSNumericType.PT, floatValue));
        } else if (styleKey.equals(RTF_MARGINBOTTOM)) {
            float floatValue = ((Float)value).floatValue();
            attr.addAttribute(PAGE_RULE_TYPE, BoxStyleKeys.MARGIN_BOTTOM.getName(), CSSNumericValue.createValue(CSSNumericType.PT, floatValue));
        } else if (styleKey.equals(RTF_LANDSCAPE)) {
            Object size = cssAttr.getAttribute(PageStyleKeys.SIZE.getName());
            if (size instanceof PageSize) {
                PageSize pageSize = (PageSize)size;
                attr.addAttribute(PAGE_RULE_TYPE, PageStyleKeys.SIZE.getName(), new PageSize(pageSize.getHeight(), pageSize.getWidth()));
            } else {
                attr.addAttribute(PAGE_RULE_TYPE, PageStyleKeys.SIZE.getName(), RTF_LANDSCAPE);
            }
        } else {
            Log.debug((Object)new Log.SimpleMessage("Unkown type of document attribute", (Object)styleKey));
            return null;
        }
        return attr;
    }

    private float twipToInt(float twips) {
        return twips * 20.0f;
    }
}

