/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.swing;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;

public class ConverterAttributeSet
extends SimpleAttributeSet {
    public static final String NOT_TYPED = "not_typed";
    private Map typeMap = new HashMap();

    public void addAttribute(Object name, Object value) {
        this.addAttribute(null, name, value);
    }

    public synchronized void addAttribute(Object type, Object name, Object value) {
        if (type == null) {
            type = NOT_TYPED;
        }
        this.typeMap.put(name, type);
        super.addAttribute(name, value);
    }

    public void addAttributes(ConverterAttributeSet attributes) {
        super.addAttributes(attributes);
        this.typeMap.putAll(attributes.getTypeMap());
    }

    public void removeAttribute(Object name) {
        super.removeAttribute(name);
        this.typeMap.remove(name);
    }

    public Map getTypeMap() {
        return this.typeMap;
    }

    public void setTypeMap(Map typeMap) {
        this.typeMap = typeMap;
    }

    public AttributeSet getAttributesByType(Object type) {
        SimpleAttributeSet attr = new SimpleAttributeSet();
        Iterator it = this.typeMap.keySet().iterator();
        while (it.hasNext()) {
            Object name = it.next();
            if (name == null || !this.typeMap.get(name).equals(type)) continue;
            attr.addAttribute(name, this.getAttribute(name));
        }
        return attr;
    }
}

