/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser.stylehandler.text;

import java.util.HashMap;
import java.util.Map;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.color.CSSSystemColors;
import org.jfree.layouting.input.style.keys.text.TextDecorationMode;
import org.jfree.layouting.input.style.keys.text.TextDecorationStyle;
import org.jfree.layouting.input.style.keys.text.TextStyleKeys;
import org.jfree.layouting.input.style.parser.CSSCompoundValueReadHandler;
import org.jfree.layouting.input.style.parser.stylehandler.OneOfConstantsReadHandler;
import org.jfree.layouting.input.style.values.CSSAutoValue;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSValue;
import org.w3c.css.sac.LexicalUnit;

public class TextDecorationReadHandler
extends OneOfConstantsReadHandler
implements CSSCompoundValueReadHandler {
    public TextDecorationReadHandler() {
        super(false);
        this.addValue(new CSSConstant("none"));
        this.addValue(new CSSConstant("underline"));
        this.addValue(new CSSConstant("overline"));
        this.addValue(new CSSConstant("line-through"));
        this.addValue(new CSSConstant("blink"));
    }

    public Map createValues(LexicalUnit unit) {
        HashMap<StyleKey, CSSValue> map = new HashMap<StyleKey, CSSValue>();
        map.put(TextStyleKeys.TEXT_UNDERLINE_POSITION, CSSAutoValue.getInstance());
        map.put(TextStyleKeys.TEXT_UNDERLINE_MODE, TextDecorationMode.CONTINUOUS);
        map.put(TextStyleKeys.TEXT_OVERLINE_MODE, TextDecorationMode.CONTINUOUS);
        map.put(TextStyleKeys.TEXT_LINE_THROUGH_MODE, TextDecorationMode.CONTINUOUS);
        map.put(TextStyleKeys.TEXT_UNDERLINE_COLOR, CSSSystemColors.CURRENT_COLOR);
        map.put(TextStyleKeys.TEXT_OVERLINE_COLOR, CSSSystemColors.CURRENT_COLOR);
        map.put(TextStyleKeys.TEXT_LINE_THROUGH_COLOR, CSSSystemColors.CURRENT_COLOR);
        map.put(TextStyleKeys.TEXT_UNDERLINE_WIDTH, CSSAutoValue.getInstance());
        map.put(TextStyleKeys.TEXT_OVERLINE_WIDTH, CSSAutoValue.getInstance());
        map.put(TextStyleKeys.TEXT_LINE_THROUGH_WIDTH, CSSAutoValue.getInstance());
        map.put(TextStyleKeys.TEXT_UNDERLINE_STYLE, TextDecorationStyle.NONE);
        map.put(TextStyleKeys.TEXT_OVERLINE_STYLE, TextDecorationStyle.NONE);
        map.put(TextStyleKeys.TEXT_LINE_THROUGH_STYLE, TextDecorationStyle.NONE);
        while (unit != null) {
            CSSValue constant = this.lookupValue(unit);
            if (constant == null) {
                return null;
            }
            if ("none".equals(constant.getCSSText())) {
                map.put(TextStyleKeys.TEXT_UNDERLINE_STYLE, TextDecorationStyle.NONE);
                map.put(TextStyleKeys.TEXT_OVERLINE_STYLE, TextDecorationStyle.NONE);
                map.put(TextStyleKeys.TEXT_LINE_THROUGH_STYLE, TextDecorationStyle.NONE);
                return map;
            }
            if ("blink".equals(constant.getCSSText())) {
                map.put(TextStyleKeys.TEXT_BLINK, new CSSConstant("blink"));
            } else if ("underline".equals(constant.getCSSText())) {
                map.put(TextStyleKeys.TEXT_UNDERLINE_STYLE, TextDecorationStyle.SOLID);
            } else if ("overline".equals(constant.getCSSText())) {
                map.put(TextStyleKeys.TEXT_OVERLINE_STYLE, TextDecorationStyle.SOLID);
            } else if ("line-through".equals(constant.getCSSText())) {
                map.put(TextStyleKeys.TEXT_LINE_THROUGH_STYLE, TextDecorationStyle.SOLID);
            }
            unit = unit.getNextLexicalUnit();
        }
        return map;
    }

    public StyleKey[] getAffectedKeys() {
        return new StyleKey[]{TextStyleKeys.TEXT_UNDERLINE_POSITION, TextStyleKeys.TEXT_UNDERLINE_MODE, TextStyleKeys.TEXT_OVERLINE_MODE, TextStyleKeys.TEXT_LINE_THROUGH_MODE, TextStyleKeys.TEXT_UNDERLINE_COLOR, TextStyleKeys.TEXT_OVERLINE_COLOR, TextStyleKeys.TEXT_LINE_THROUGH_COLOR, TextStyleKeys.TEXT_UNDERLINE_WIDTH, TextStyleKeys.TEXT_OVERLINE_WIDTH, TextStyleKeys.TEXT_LINE_THROUGH_WIDTH, TextStyleKeys.TEXT_UNDERLINE_STYLE, TextStyleKeys.TEXT_OVERLINE_STYLE, TextStyleKeys.TEXT_LINE_THROUGH_STYLE};
    }
}

