/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser.stylehandler.content;

import java.util.ArrayList;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.content.ContentValues;
import org.jfree.layouting.input.style.keys.list.ListStyleTypeGlyphs;
import org.jfree.layouting.input.style.parser.CSSValueFactory;
import org.jfree.layouting.input.style.parser.stylehandler.OneOfConstantsReadHandler;
import org.jfree.layouting.input.style.values.CSSAttrFunction;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSFunctionValue;
import org.jfree.layouting.input.style.values.CSSStringValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValueList;
import org.w3c.css.sac.LexicalUnit;

public class StringSetReadHandler
extends OneOfConstantsReadHandler {
    public StringSetReadHandler() {
        super(false);
        this.addValue(ContentValues.CLOSE_QUOTE);
        this.addValue(ContentValues.CONTENTS);
        this.addValue(ContentValues.DOCUMENT_URL);
        this.addValue(ContentValues.ENDNOTE);
        this.addValue(ContentValues.FOOTNOTE);
        this.addValue(ContentValues.LISTITEM);
        this.addValue(ContentValues.NO_CLOSE_QUOTE);
        this.addValue(ContentValues.NO_OPEN_QUOTE);
        this.addValue(ContentValues.NONE);
        this.addValue(ContentValues.OPEN_QUOTE);
        this.addValue(ContentValues.SECTIONNOTE);
        this.addValue(ListStyleTypeGlyphs.BOX);
        this.addValue(ListStyleTypeGlyphs.CHECK);
        this.addValue(ListStyleTypeGlyphs.CIRCLE);
        this.addValue(ListStyleTypeGlyphs.DIAMOND);
        this.addValue(ListStyleTypeGlyphs.DISC);
        this.addValue(ListStyleTypeGlyphs.HYPHEN);
        this.addValue(ListStyleTypeGlyphs.SQUARE);
    }

    public CSSValue createValue(StyleKey name, LexicalUnit value) {
        CSSValueList sequence;
        CSSValue[] values;
        ArrayList<CSSValueList> contents = new ArrayList<CSSValueList>();
        ArrayList<CSSValue> contentList = new ArrayList<CSSValue>();
        while (value != null) {
            if (value.getLexicalUnitType() == 35) {
                CSSValue o = this.lookupValue(value);
                if (o == null) {
                    return null;
                }
                contentList.add(o);
            } else if (value.getLexicalUnitType() == 36) {
                contentList.add(new CSSConstant(value.getStringValue()));
            } else if (value.getLexicalUnitType() == 24) {
                CSSStringValue uriValue = CSSValueFactory.createUriValue(value);
                if (uriValue == null) {
                    return null;
                }
                contentList.add(uriValue);
            } else if (value.getLexicalUnitType() == 41 || value.getLexicalUnitType() == 25 || value.getLexicalUnitType() == 26) {
                CSSFunctionValue functionValue = CSSValueFactory.parseFunction(value);
                if (functionValue == null) {
                    return null;
                }
                contentList.add(functionValue);
            } else if (value.getLexicalUnitType() == 37) {
                CSSAttrFunction attrFn = CSSValueFactory.parseAttrFunction(value);
                if (attrFn == null) {
                    return null;
                }
                contentList.add(attrFn);
            } else if (value.getLexicalUnitType() == 0) {
                values = contentList.toArray(new CSSValue[contentList.size()]);
                sequence = new CSSValueList(values);
                contents.add(sequence);
            }
            value = value.getNextLexicalUnit();
        }
        values = contentList.toArray(new CSSValue[contentList.size()]);
        sequence = new CSSValueList(values);
        contents.add(sequence);
        return new CSSValueList(contents);
    }
}

