/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser.stylehandler.content;

import java.util.ArrayList;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.parser.CSSValueFactory;
import org.jfree.layouting.input.style.parser.CSSValueReadHandler;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValueList;
import org.jfree.layouting.input.style.values.CSSValuePair;
import org.w3c.css.sac.LexicalUnit;

public class CounterModificationReadHandler
implements CSSValueReadHandler {
    public static final CSSNumericValue ZERO = CSSNumericValue.createValue(CSSNumericType.NUMBER, 0.0);

    public CSSValue createValue(StyleKey name, LexicalUnit value) {
        if (value.getLexicalUnitType() != 35) {
            return null;
        }
        String mayBeNone = value.getStringValue();
        if ("none".equalsIgnoreCase(mayBeNone)) {
            return new CSSConstant("none");
        }
        ArrayList<CSSValuePair> counterSpecs = new ArrayList<CSSValuePair>();
        while (value != null) {
            if (value.getLexicalUnitType() != 35) {
                return null;
            }
            String identifier = value.getStringValue();
            value = value.getNextLexicalUnit();
            CSSValue counterValue = ZERO;
            if (value != null) {
                if (value.getLexicalUnitType() == 13) {
                    counterValue = CSSNumericValue.createValue(CSSNumericType.NUMBER, value.getIntegerValue());
                    value = value.getNextLexicalUnit();
                } else if (value.getLexicalUnitType() == 37) {
                    counterValue = CSSValueFactory.parseAttrFunction(value);
                    value = value.getNextLexicalUnit();
                } else if (CSSValueFactory.isFunctionValue(value)) {
                    counterValue = CSSValueFactory.parseFunction(value);
                    value = value.getNextLexicalUnit();
                }
            }
            counterSpecs.add(new CSSValuePair(new CSSConstant(identifier), counterValue));
        }
        return new CSSValueList(counterSpecs);
    }
}

