/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser.stylehandler.box;

import java.util.HashMap;
import java.util.Map;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.box.BoxStyleKeys;
import org.jfree.layouting.input.style.parser.CSSCompoundValueReadHandler;
import org.jfree.layouting.input.style.parser.stylehandler.AbstractWidthReadHandler;
import org.jfree.layouting.input.style.values.CSSValue;
import org.w3c.css.sac.LexicalUnit;

public class MarginReadHandler
extends AbstractWidthReadHandler
implements CSSCompoundValueReadHandler {
    public MarginReadHandler() {
        super(true, true);
    }

    public Map createValues(LexicalUnit unit) {
        CSSValue leftWidth;
        CSSValue bottomWidth;
        CSSValue rightWidth;
        CSSValue topWidth = this.parseWidth(unit);
        if (topWidth == null) {
            return null;
        }
        if ((unit = unit.getNextLexicalUnit()) == null) {
            rightWidth = topWidth;
        } else {
            rightWidth = this.parseWidth(unit);
            if (rightWidth == null) {
                return null;
            }
            unit = unit.getNextLexicalUnit();
        }
        if (unit == null) {
            bottomWidth = topWidth;
        } else {
            bottomWidth = this.parseWidth(unit);
            if (bottomWidth == null) {
                return null;
            }
            unit = unit.getNextLexicalUnit();
        }
        if (unit == null) {
            leftWidth = rightWidth;
        } else {
            leftWidth = this.parseWidth(unit);
            if (leftWidth == null) {
                return null;
            }
        }
        HashMap<StyleKey, CSSValue> map = new HashMap<StyleKey, CSSValue>();
        map.put(BoxStyleKeys.MARGIN_TOP, topWidth);
        map.put(BoxStyleKeys.MARGIN_RIGHT, rightWidth);
        map.put(BoxStyleKeys.MARGIN_BOTTOM, bottomWidth);
        map.put(BoxStyleKeys.MARGIN_LEFT, leftWidth);
        return map;
    }

    public StyleKey[] getAffectedKeys() {
        return new StyleKey[]{BoxStyleKeys.MARGIN_TOP, BoxStyleKeys.MARGIN_RIGHT, BoxStyleKeys.MARGIN_BOTTOM, BoxStyleKeys.MARGIN_LEFT};
    }
}

