/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser.stylehandler.border;

import java.util.HashMap;
import java.util.Map;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.border.BorderStyle;
import org.jfree.layouting.input.style.keys.border.BorderStyleKeys;
import org.jfree.layouting.input.style.parser.CSSCompoundValueReadHandler;
import org.jfree.layouting.input.style.parser.stylehandler.OneOfConstantsReadHandler;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.w3c.css.sac.LexicalUnit;

public class BorderStyleReadHandler
extends OneOfConstantsReadHandler
implements CSSCompoundValueReadHandler {
    public BorderStyleReadHandler() {
        super(false);
        this.addValue(BorderStyle.DASHED);
        this.addValue(BorderStyle.DOT_DASH);
        this.addValue(BorderStyle.DOT_DOT_DASH);
        this.addValue(BorderStyle.DOTTED);
        this.addValue(BorderStyle.DOUBLE);
        this.addValue(BorderStyle.GROOVE);
        this.addValue(BorderStyle.HIDDEN);
        this.addValue(BorderStyle.INSET);
        this.addValue(BorderStyle.NONE);
        this.addValue(BorderStyle.OUTSET);
        this.addValue(BorderStyle.RIDGE);
        this.addValue(BorderStyle.SOLID);
        this.addValue(BorderStyle.WAVE);
    }

    public Map createValues(LexicalUnit unit) {
        CSSConstant leftStyle;
        CSSConstant bottomStyle;
        CSSConstant rightStyle;
        CSSConstant topStyle = (CSSConstant)this.lookupValue(unit);
        if (topStyle == null) {
            return null;
        }
        if ((unit = unit.getNextLexicalUnit()) == null) {
            rightStyle = topStyle;
        } else {
            rightStyle = (CSSConstant)this.lookupValue(unit);
            if (rightStyle == null) {
                return null;
            }
            unit = unit.getNextLexicalUnit();
        }
        if (unit == null) {
            bottomStyle = topStyle;
        } else {
            bottomStyle = (CSSConstant)this.lookupValue(unit);
            if (bottomStyle == null) {
                return null;
            }
            unit = unit.getNextLexicalUnit();
        }
        if (unit == null) {
            leftStyle = rightStyle;
        } else {
            leftStyle = (CSSConstant)this.lookupValue(unit);
            if (leftStyle == null) {
                return null;
            }
        }
        HashMap<StyleKey, CSSConstant> map = new HashMap<StyleKey, CSSConstant>();
        map.put(BorderStyleKeys.BORDER_TOP_STYLE, topStyle);
        map.put(BorderStyleKeys.BORDER_RIGHT_STYLE, rightStyle);
        map.put(BorderStyleKeys.BORDER_BOTTOM_STYLE, bottomStyle);
        map.put(BorderStyleKeys.BORDER_LEFT_STYLE, leftStyle);
        return map;
    }

    public StyleKey[] getAffectedKeys() {
        return new StyleKey[]{BorderStyleKeys.BORDER_TOP_STYLE, BorderStyleKeys.BORDER_RIGHT_STYLE, BorderStyleKeys.BORDER_BOTTOM_STYLE, BorderStyleKeys.BORDER_LEFT_STYLE};
    }
}

