/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser.stylehandler.border;

import java.util.ArrayList;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.border.BackgroundRepeat;
import org.jfree.layouting.input.style.parser.CSSValueFactory;
import org.jfree.layouting.input.style.parser.CSSValueReadHandler;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValueList;
import org.jfree.layouting.input.style.values.CSSValuePair;
import org.w3c.css.sac.LexicalUnit;

public class BackgroundRepeatReadHandler
implements CSSValueReadHandler {
    public CSSValue createValue(StyleKey name, LexicalUnit value) {
        ArrayList<CSSValuePair> values = new ArrayList<CSSValuePair>();
        while (value != null) {
            CSSConstant vertical;
            CSSConstant horizontal;
            if (value.getLexicalUnitType() != 35) {
                return null;
            }
            String horizontalString = value.getStringValue();
            if ("repeat-x".equalsIgnoreCase(horizontalString)) {
                horizontal = BackgroundRepeat.REPEAT;
                vertical = BackgroundRepeat.NOREPEAT;
            } else if ("repeat-y".equalsIgnoreCase(value.getStringValue())) {
                horizontal = BackgroundRepeat.NOREPEAT;
                vertical = BackgroundRepeat.REPEAT;
            } else {
                horizontal = this.translateRepeat(horizontalString);
                if (horizontal == null) {
                    return null;
                }
                if ((value = value.getNextLexicalUnit()) == null) {
                    vertical = horizontal;
                } else {
                    if (value.getLexicalUnitType() != 35) {
                        return null;
                    }
                    vertical = this.translateRepeat(value.getStringValue());
                    if (vertical == null) {
                        return null;
                    }
                }
            }
            values.add(new CSSValuePair(horizontal, vertical));
            value = CSSValueFactory.parseComma(value);
        }
        return new CSSValueList(values);
    }

    private CSSConstant translateRepeat(String value) {
        if ("repeat".equalsIgnoreCase(value)) {
            return BackgroundRepeat.REPEAT;
        }
        if ("no-repeat".equalsIgnoreCase(value)) {
            return BackgroundRepeat.NOREPEAT;
        }
        if ("space".equalsIgnoreCase(value)) {
            return BackgroundRepeat.SPACE;
        }
        return null;
    }
}

