/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser.stylehandler;

import java.util.ArrayList;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.parser.CSSValueFactory;
import org.jfree.layouting.input.style.parser.CSSValueReadHandler;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValueList;
import org.w3c.css.sac.LexicalUnit;

public abstract class ListOfValuesReadHandler
implements CSSValueReadHandler {
    private int maxCount;
    private boolean distinctValues;

    protected ListOfValuesReadHandler() {
        this.maxCount = Integer.MAX_VALUE;
        this.distinctValues = false;
    }

    protected ListOfValuesReadHandler(int maxCount, boolean distinct) {
        this.maxCount = maxCount;
        this.distinctValues = distinct;
    }

    public boolean isDistinctValues() {
        return this.distinctValues;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public CSSValue createValue(StyleKey name, LexicalUnit value) {
        ArrayList<CSSValue> list = new ArrayList<CSSValue>();
        for (int count = 0; value != null && count < this.maxCount; ++count) {
            CSSValue pvalue = this.parseValue(value);
            if (pvalue == null) {
                return null;
            }
            if (!this.distinctValues || !list.contains(pvalue)) {
                list.add(pvalue);
            }
            value = CSSValueFactory.parseComma(value);
        }
        return new CSSValueList(list);
    }

    protected abstract CSSValue parseValue(LexicalUnit var1);
}

