/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.jfree.layouting.input.style.CSSDeclarationRule;
import org.jfree.layouting.input.style.CSSFontFaceRule;
import org.jfree.layouting.input.style.CSSMediaRule;
import org.jfree.layouting.input.style.CSSPageAreaRule;
import org.jfree.layouting.input.style.CSSPageRule;
import org.jfree.layouting.input.style.CSSStyleRule;
import org.jfree.layouting.input.style.PageAreaType;
import org.jfree.layouting.input.style.StyleKeyRegistry;
import org.jfree.layouting.input.style.StyleRule;
import org.jfree.layouting.input.style.StyleSheet;
import org.jfree.layouting.input.style.parser.CSSParserContext;
import org.jfree.layouting.input.style.parser.CSSValueFactory;
import org.jfree.layouting.input.style.parser.StyleSheetParserUtil;
import org.jfree.layouting.input.style.selectors.CSSSelector;
import org.jfree.resourceloader.DependencyCollector;
import org.jfree.resourceloader.Resource;
import org.jfree.resourceloader.ResourceException;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceManager;
import org.jfree.util.FastStack;
import org.jfree.util.Log;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;

public class StyleSheetHandler
implements DocumentHandler,
ErrorHandler {
    private HashMap namespaces = new HashMap();
    private StyleKeyRegistry registry;
    private StyleSheet styleSheet;
    private FastStack parentRules = new FastStack();
    private CSSDeclarationRule styleRule;
    private ResourceKey source;
    private DependencyCollector dependencies;
    private String defaultNamespace;
    private ResourceManager manager;
    static /* synthetic */ Class class$org$jfree$layouting$input$style$StyleSheet;

    public void init(ResourceManager manager, ResourceKey source, long version, StyleKeyRegistry registry, StyleRule parentRule) {
        if (registry == null) {
            throw new NullPointerException();
        }
        this.registry = registry;
        this.parentRules.clear();
        if (parentRule != null) {
            this.parentRules.push((Object)parentRule);
        }
        this.manager = manager;
        this.source = source;
        if (source != null) {
            this.dependencies = new DependencyCollector(source, version);
        }
        this.namespaces.clear();
    }

    public void registerNamespace(String prefix, String uri) {
        if (prefix == null) {
            throw new NullPointerException();
        }
        if (uri == null) {
            throw new NullPointerException();
        }
        this.namespaces.put(prefix, uri);
    }

    public String getDefaultNamespaceURI() {
        return this.defaultNamespace;
    }

    public void setDefaultNamespaceURI(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    public ResourceKey getSource() {
        return this.source;
    }

    public DependencyCollector getDependencies() {
        return this.dependencies;
    }

    public CSSDeclarationRule getStyleRule() {
        return this.styleRule;
    }

    public void setStyleRule(CSSDeclarationRule styleRule) {
        this.styleRule = styleRule;
    }

    public StyleSheet getStyleSheet() {
        return this.styleSheet;
    }

    public void setStyleSheet(StyleSheet styleSheet) {
        this.styleSheet = styleSheet;
    }

    public ResourceManager getResourceManager() {
        return this.manager;
    }

    public void initParseContext(InputSource source) {
        CSSParserContext.getContext().setNamespaces(this.namespaces);
        CSSParserContext.getContext().setStyleKeyRegistry(this.registry);
        CSSParserContext.getContext().setSource(this.getSource());
    }

    public void startDocument(InputSource source) throws CSSException {
        this.initParseContext(source);
        if (this.styleSheet == null) {
            this.styleSheet = new StyleSheet();
            this.styleSheet.setSource(this.getSource());
        }
    }

    public void endDocument(InputSource source) throws CSSException {
        Iterator entries = this.namespaces.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            String prefix = (String)entry.getKey();
            String uri = (String)entry.getValue();
            this.styleSheet.addNamespace(prefix, uri);
        }
    }

    public void comment(String text) throws CSSException {
    }

    public void ignorableAtRule(String atRule) throws CSSException {
        StringTokenizer strtok = new StringTokenizer(atRule);
        if (!strtok.hasMoreTokens()) {
            return;
        }
        String ruleName = strtok.nextToken();
        if ("@namespace".equalsIgnoreCase(ruleName)) {
            this.parseNamespaceRule(strtok);
        } else if (this.styleRule instanceof CSSPageRule) {
            CSSPageRule pageRule = (CSSPageRule)this.styleRule;
            if (ruleName.length() <= 1) {
                return;
            }
            String areaName = ruleName.substring(1);
            PageAreaType[] pageAreas = PageAreaType.getPageAreas();
            for (int i = 0; i < pageAreas.length; ++i) {
                PageAreaType pageArea = pageAreas[i];
                if (!areaName.equalsIgnoreCase(pageArea.getName())) continue;
                CSSPageAreaRule areaRule = this.parsePageRule(pageArea, atRule);
                if (areaRule != null) {
                    pageRule.addRule(areaRule);
                }
                return;
            }
            Log.info((Object)("Did not recognize page @rule: " + atRule));
        } else {
            Log.info((Object)("Ignorable @rule: " + atRule));
        }
    }

    private CSSPageAreaRule parsePageRule(PageAreaType areaType, String atRule) {
        ResourceManager manager = this.getResourceManager();
        ResourceKey source = this.source;
        CSSPageAreaRule areaRule = new CSSPageAreaRule(this.styleSheet, this.styleRule, areaType);
        int firstBrace = atRule.indexOf(123);
        int lastBrace = atRule.indexOf(125);
        if (firstBrace < 0 || lastBrace < firstBrace) {
            return null;
        }
        StyleSheetParserUtil.getInstance().parseStyleRule(this.namespaces, atRule.substring(firstBrace + 1, lastBrace - 1), manager, source, areaRule);
        return areaRule;
    }

    private void parseNamespaceRule(StringTokenizer strtok) {
        String uri;
        String prefix;
        String next = strtok.nextToken();
        if (next.startsWith("url(")) {
            prefix = "";
            uri = next;
        } else {
            prefix = next;
            if (!strtok.hasMoreTokens()) {
                return;
            }
            uri = strtok.nextToken();
        }
        int uriStart = uri.indexOf(40);
        if (uriStart == -1) {
            return;
        }
        int uriEnd = uri.indexOf(41);
        if (uriEnd == -1) {
            return;
        }
        if (uriStart > uriEnd) {
            return;
        }
        String uriValue = uri.substring(uriStart + 1, uriEnd);
        this.namespaceDeclaration(prefix, uriValue);
    }

    public void namespaceDeclaration(String prefix, String uri) throws CSSException {
        if (prefix == null || "".equals(prefix)) {
            this.namespaces.put("", uri);
            this.defaultNamespace = uri;
            CSSParserContext.getContext().setDefaultNamespace(this.defaultNamespace);
        } else {
            this.namespaces.put(prefix, uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException {
        ResourceManager manager = this.getResourceManager();
        if (manager == null) {
            return;
        }
        try {
            CSSParserContext.getContext().setDefaultNamespace(defaultNamespaceURI);
            ResourceKey key = this.source == null ? manager.createKey((Object)uri) : manager.deriveKey(this.source, uri);
            Resource res = manager.create(key, this.source, class$org$jfree$layouting$input$style$StyleSheet == null ? (class$org$jfree$layouting$input$style$StyleSheet = StyleSheetHandler.class$("org.jfree.layouting.input.style.StyleSheet")) : class$org$jfree$layouting$input$style$StyleSheet);
            if (res == null) {
                return;
            }
            StyleSheet styleSheet = (StyleSheet)res.getResource();
            this.styleSheet.addStyleSheet(styleSheet);
        }
        catch (ResourceException e) {
        }
        finally {
            CSSParserContext.getContext().setStyleKeyRegistry(this.registry);
            CSSParserContext.getContext().setSource(this.getSource());
            CSSParserContext.getContext().setNamespaces(this.namespaces);
            CSSParserContext.getContext().setDefaultNamespace(this.defaultNamespace);
        }
    }

    public void startMedia(SACMediaList media) throws CSSException {
        this.styleRule = new CSSMediaRule(this.styleSheet, this.getParentRule());
        this.parentRules.push((Object)this.styleRule);
    }

    public void endMedia(SACMediaList media) throws CSSException {
        this.parentRules.pop();
        this.styleSheet.addRule(this.styleRule);
        this.styleRule = null;
    }

    public void startPage(String name, String pseudo_page) throws CSSException {
        this.styleRule = new CSSPageRule(this.styleSheet, this.getParentRule(), name, pseudo_page);
        this.parentRules.push((Object)this.styleRule);
    }

    public void endPage(String name, String pseudo_page) throws CSSException {
        this.parentRules.pop();
        this.styleSheet.addRule(this.styleRule);
        this.styleRule = null;
    }

    public void startFontFace() throws CSSException {
        this.styleRule = new CSSFontFaceRule(this.styleSheet, this.getParentRule());
        this.parentRules.push((Object)this.styleRule);
    }

    protected StyleRule getParentRule() {
        if (!this.parentRules.isEmpty()) {
            return (StyleRule)this.parentRules.peek();
        }
        return null;
    }

    public void endFontFace() throws CSSException {
        this.parentRules.pop();
    }

    public void startSelector(SelectorList selectors) throws CSSException {
        this.styleRule = new CSSStyleRule(this.styleSheet, this.getParentRule());
    }

    public void endSelector(SelectorList selectors) throws CSSException {
        if (this.styleRule.getSize() == 0) {
            return;
        }
        int length = selectors.getLength();
        for (int i = 0; i < length; ++i) {
            Selector selector = selectors.item(i);
            try {
                CSSStyleRule rule = (CSSStyleRule)this.styleRule.clone();
                rule.setSelector((CSSSelector)selector);
                this.styleSheet.addRule(rule);
                continue;
            }
            catch (CloneNotSupportedException e) {
                // empty catch block
            }
        }
    }

    public void property(String name, LexicalUnit value, boolean important) throws CSSException {
        CSSValueFactory factory = CSSParserContext.getContext().getValueFactory();
        try {
            factory.parseValue(this.styleRule, name, value, important);
        }
        catch (Exception e) {
            Log.warn((Object)("Error parsing style key: " + name), (Exception)e);
        }
    }

    public void warning(CSSParseException exception) throws CSSException {
        Log.warn((Object)("Warning: " + exception.getMessage()));
    }

    public void error(CSSParseException exception) throws CSSException {
        Log.warn((Object)"Error: ", (Exception)exception);
    }

    public void fatalError(CSSParseException exception) throws CSSException {
        Log.warn((Object)"Fatal Error: ", (Exception)exception);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

