/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser;

import java.io.IOException;
import java.io.InputStream;
import org.jfree.layouting.input.style.StyleKeyRegistry;
import org.jfree.layouting.input.style.parser.CSSParserContext;
import org.jfree.layouting.input.style.parser.CSSParserFactory;
import org.jfree.layouting.input.style.parser.CSSParserInstantiationException;
import org.jfree.layouting.input.style.parser.StyleSheetHandler;
import org.jfree.resourceloader.CompoundResource;
import org.jfree.resourceloader.DependencyCollector;
import org.jfree.resourceloader.Resource;
import org.jfree.resourceloader.ResourceCreationException;
import org.jfree.resourceloader.ResourceData;
import org.jfree.resourceloader.ResourceFactory;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceLoadingException;
import org.jfree.resourceloader.ResourceManager;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;

public class StyleSheetFactory
implements ResourceFactory {
    static /* synthetic */ Class class$org$jfree$layouting$input$style$StyleSheet;

    public Resource create(ResourceManager manager, ResourceData data, ResourceKey context) throws ResourceCreationException, ResourceLoadingException {
        try {
            long version;
            ResourceKey key;
            Parser parser = CSSParserFactory.getInstance().createCSSParser();
            if (context == null) {
                key = data.getKey();
                version = data.getVersion(manager);
            } else {
                key = context;
                version = -1L;
            }
            StyleSheetHandler handler = new StyleSheetHandler();
            handler.init(manager, key, version, StyleKeyRegistry.getRegistry(), null);
            parser.setDocumentHandler((DocumentHandler)handler);
            parser.setErrorHandler((ErrorHandler)handler);
            InputStream stream = data.getResourceAsStream(manager);
            InputSource inputSource = new InputSource();
            inputSource.setByteStream(stream);
            parser.parseStyleSheet(inputSource);
            DependencyCollector dependencies = handler.getDependencies();
            if (context != null) {
                dependencies.add(data.getKey(), data.getVersion(manager));
            }
            CSSParserContext.getContext().destroy();
            CompoundResource cr = new CompoundResource(data.getKey(), dependencies, (Object)handler.getStyleSheet());
            return cr;
        }
        catch (CSSParserInstantiationException e) {
            throw new ResourceCreationException("Failed to parse the stylesheet.");
        }
        catch (IOException e) {
            throw new ResourceLoadingException("Failed to load the stylesheet.");
        }
    }

    public Class getFactoryType() {
        return class$org$jfree$layouting$input$style$StyleSheet == null ? (class$org$jfree$layouting$input$style$StyleSheet = StyleSheetFactory.class$("org.jfree.layouting.input.style.StyleSheet")) : class$org$jfree$layouting$input$style$StyleSheet;
    }

    public void initializeDefaults() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

