/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.jfree.layouting.input.style.CSSStyleRule;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.StyleRule;
import org.jfree.layouting.input.style.StyleSheet;
import org.jfree.layouting.input.style.parser.StyleSheetParserUtil;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceManager;

public abstract class CSSDeclarationRule
extends StyleRule {
    private HashMap declarations = new HashMap();
    private HashSet importantDeclarations = new HashSet();
    private transient StyleKey[] declaredKeys;
    private StyleSheetParserUtil styleSheetParserUtil;

    protected CSSDeclarationRule(StyleSheet parentStyle, StyleRule parentRule) {
        super(parentStyle, parentRule);
    }

    public boolean isImportant(StyleKey propertyName) {
        return this.importantDeclarations.contains(propertyName);
    }

    public void setImportant(StyleKey propertyName, boolean important) {
        if (important) {
            this.importantDeclarations.add(propertyName);
        } else {
            this.importantDeclarations.remove(propertyName);
        }
    }

    public CSSValue getPropertyCSSValue(StyleKey propertyName) {
        return (CSSValue)this.declarations.get(propertyName);
    }

    public void setPropertyValueAsString(StyleKey styleKey, String value) {
        this.setPropertyValueAsString(styleKey.getName(), value);
    }

    public void setPropertyValueAsString(String name, String value) {
        block8: {
            ResourceManager resourceManager;
            ResourceKey source;
            block7: {
                StyleSheet parent;
                if (value == null) {
                    throw new NullPointerException();
                }
                StyleSheet parentStyle = this.getParentStyle();
                if (parentStyle == null) {
                    source = null;
                    resourceManager = null;
                } else {
                    source = parentStyle.getSource();
                    resourceManager = parentStyle.getResourceManager();
                }
                if (this.styleSheetParserUtil == null) {
                    this.styleSheetParserUtil = new StyleSheetParserUtil();
                }
                if ((parent = this.getParentStyle()) == null) break block7;
                CSSStyleRule cssValues = this.styleSheetParserUtil.parseStyles(parent.getNamespaces(), name, value, resourceManager, source);
                if (cssValues == null) break block8;
                Iterator keys = cssValues.getPropertyKeys();
                while (keys.hasNext()) {
                    StyleKey key = (StyleKey)keys.next();
                    this.setPropertyValue(key, cssValues.getPropertyCSSValue(key));
                    this.setImportant(key, cssValues.isImportant(key));
                }
                break block8;
            }
            CSSStyleRule cssValues = this.styleSheetParserUtil.parseStyles(null, name, value, resourceManager, source);
            if (cssValues != null) {
                Iterator keys = cssValues.getPropertyKeys();
                while (keys.hasNext()) {
                    StyleKey key = (StyleKey)keys.next();
                    this.setPropertyValue(key, cssValues.getPropertyCSSValue(key));
                    this.setImportant(key, cssValues.isImportant(key));
                }
            }
        }
    }

    public void setPropertyValue(StyleKey propertyName, CSSValue value) {
        if (value == null) {
            this.declarations.remove(propertyName);
        } else {
            this.declarations.put(propertyName, value);
        }
        this.declaredKeys = null;
    }

    public void removeProperty(StyleKey name) {
        this.declarations.remove(name);
        this.declaredKeys = null;
    }

    public void clear() {
        this.declarations.clear();
        this.declaredKeys = null;
    }

    public Iterator getPropertyKeys() {
        return this.declarations.keySet().iterator();
    }

    public StyleKey[] getPropertyKeysAsArray() {
        if (this.declaredKeys == null) {
            this.declaredKeys = this.declarations.keySet().toArray(new StyleKey[this.declarations.size()]);
        }
        return (StyleKey[])this.declaredKeys.clone();
    }

    public Iterator getImportantKeys() {
        return this.importantDeclarations.iterator();
    }

    public int getSize() {
        return this.declarations.size();
    }

    public Object clone() throws CloneNotSupportedException {
        CSSDeclarationRule rule = (CSSDeclarationRule)super.clone();
        rule.declarations = (HashMap)this.declarations.clone();
        rule.importantDeclarations = (HashSet)this.importantDeclarations.clone();
        rule.styleSheetParserUtil = null;
        return rule;
    }
}

