/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting;

import java.util.Date;
import org.jfree.layouting.layouter.context.DocumentContext;
import org.jfree.layouting.layouter.context.LayoutStyle;
import org.jfree.layouting.layouter.i18n.DefaultLocalizationContext;
import org.jfree.layouting.layouter.i18n.LocalizationContext;
import org.jfree.layouting.layouter.style.resolver.SimpleStyleRuleMatcher;
import org.jfree.layouting.layouter.style.resolver.StyleRuleMatcher;
import org.jfree.resourceloader.ResourceKey;
import org.jfree.resourceloader.ResourceManager;

public class DocumentContextUtility {
    private DocumentContextUtility() {
    }

    public static ResourceKey getBaseResource(DocumentContext context) {
        Object o = context.getMetaAttribute("base-resource");
        if (!(o instanceof ResourceKey)) {
            return null;
        }
        return (ResourceKey)o;
    }

    public static LocalizationContext getLocalizationContext(DocumentContext context) {
        Object o = context.getMetaAttribute("localization-context");
        if (!(o instanceof LocalizationContext)) {
            DefaultLocalizationContext value = new DefaultLocalizationContext();
            context.setMetaAttribute("localization-context", value);
            return value;
        }
        return (LocalizationContext)o;
    }

    public static ResourceManager getResourceManager(DocumentContext context) {
        Object o = context.getMetaAttribute("resource-manager");
        if (!(o instanceof ResourceManager)) {
            ResourceManager value = new ResourceManager();
            value.registerDefaults();
            context.setMetaAttribute("resource-manager", value);
            return value;
        }
        return (ResourceManager)o;
    }

    public static Date getDate(DocumentContext context) {
        Object o = context.getMetaAttribute("date");
        if (!(o instanceof Date)) {
            Date value = new Date();
            context.setMetaAttribute("date", value);
            return value;
        }
        return (Date)o;
    }

    public static StyleRuleMatcher getStyleRuleMatcher(DocumentContext context) {
        Object o = context.getMetaAttribute("style-matcher");
        if (!(o instanceof StyleRuleMatcher)) {
            SimpleStyleRuleMatcher value = new SimpleStyleRuleMatcher();
            context.setMetaAttribute("style-matcher", value);
            return value;
        }
        return (StyleRuleMatcher)o;
    }

    public static LayoutStyle getInitialStyle(DocumentContext context) {
        Object o = context.getMetaAttribute("initial-style");
        if (!(o instanceof LayoutStyle)) {
            throw new IllegalStateException();
        }
        return (LayoutStyle)o;
    }
}

