/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.LayoutProcessState;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.input.style.PseudoPage;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.DocumentContext;
import org.jfree.layouting.layouter.feed.InputFeed;
import org.jfree.layouting.layouter.style.resolver.StyleResolver;
import org.jfree.layouting.normalizer.content.NormalizationException;
import org.jfree.layouting.normalizer.content.Normalizer;
import org.jfree.layouting.output.ChainingOutputProcessor;
import org.jfree.layouting.output.OutputProcessor;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.resourceloader.ResourceManager;

public class ChainingLayoutProcess
implements LayoutProcess {
    private LayoutProcess chainedLayoutProcess;
    private ChainingOutputProcessor outputProcessor;
    private InputFeed inputFeed;

    public ChainingLayoutProcess(LayoutProcess layoutProcess) {
        this.chainedLayoutProcess = layoutProcess;
        this.outputProcessor = new ChainingOutputProcessor(layoutProcess.getOutputProcessor());
    }

    public InputFeed getInputFeed() {
        if (this.inputFeed == null) {
            this.inputFeed = this.outputProcessor.createInputFeed(this);
        }
        return this.inputFeed;
    }

    public StyleResolver getStyleResolver() {
        return this.chainedLayoutProcess.getStyleResolver();
    }

    public DocumentContext getDocumentContext() {
        return this.chainedLayoutProcess.getDocumentContext();
    }

    public OutputProcessorMetaData getOutputMetaData() {
        return this.chainedLayoutProcess.getOutputMetaData();
    }

    public OutputProcessor getOutputProcessor() {
        return this.outputProcessor;
    }

    public ResourceManager getResourceManager() {
        return this.chainedLayoutProcess.getResourceManager();
    }

    public void pageBreakEncountered(CSSValue pageName, PseudoPage[] pseudoPages) throws NormalizationException {
        this.getInputFeed().handlePageBreakEncountered(pageName, pseudoPages);
    }

    public boolean isPagebreakEncountered() {
        return this.getInputFeed().isPagebreakEncountered();
    }

    public LayoutProcess getChainedLayoutProcess() {
        return this.chainedLayoutProcess;
    }

    public void setChainedLayoutProcess(LayoutProcess chainedLayoutProcess) {
        this.chainedLayoutProcess = chainedLayoutProcess;
    }

    public LayoutProcessState saveState() throws StateException {
        ChainingLayoutProcessState state = new ChainingLayoutProcessState();
        state.setInputFeed(this.inputFeed.saveState());
        state.setChainedLayoutProcess(this.chainedLayoutProcess.saveState());
        return state;
    }

    public Normalizer getNormalizer() {
        if (this.inputFeed == null) {
            throw new IllegalStateException("We cant have come that far without an input feed.");
        }
        return this.inputFeed.getCurrentNormalizer();
    }

    private static class ChainingLayoutProcessState
    implements LayoutProcessState {
        private LayoutProcessState chainedLayoutProcess;
        private State inputFeed;

        private ChainingLayoutProcessState() {
        }

        public LayoutProcessState getChainedLayoutProcess() {
            return this.chainedLayoutProcess;
        }

        public void setChainedLayoutProcess(LayoutProcessState chainedLayoutProcess) {
            this.chainedLayoutProcess = chainedLayoutProcess;
        }

        public State getInputFeed() {
            return this.inputFeed;
        }

        public void setInputFeed(State inputFeed) {
            this.inputFeed = inputFeed;
        }

        public LayoutProcess restore(OutputProcessor outputProcessor) throws StateException {
            LayoutProcess root = this.chainedLayoutProcess.restore(outputProcessor);
            ChainingLayoutProcess proc = new ChainingLayoutProcess(root);
            proc.outputProcessor = new ChainingOutputProcessor(outputProcessor);
            if (this.inputFeed != null) {
                proc.inputFeed = (InputFeed)this.inputFeed.restore(proc);
                if (proc.inputFeed == null) {
                    throw new StateException();
                }
            }
            return proc;
        }
    }
}

