/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.LayoutProcessState;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.input.style.PseudoPage;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.DefaultDocumentContext;
import org.jfree.layouting.layouter.context.DocumentContext;
import org.jfree.layouting.layouter.feed.InputFeed;
import org.jfree.layouting.layouter.style.resolver.DefaultStyleResolver;
import org.jfree.layouting.layouter.style.resolver.StyleResolver;
import org.jfree.layouting.normalizer.content.NormalizationException;
import org.jfree.layouting.normalizer.content.Normalizer;
import org.jfree.layouting.output.OutputProcessor;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.resourceloader.ResourceManager;

public abstract class AbstractLayoutProcess
implements LayoutProcess {
    private InputFeed inputFeed;
    private DocumentContext documentContext;
    private OutputProcessor outputProcessor;
    private StyleResolver styleResolver;

    protected AbstractLayoutProcess(OutputProcessor outputProcessor) {
        if (outputProcessor == null) {
            throw new NullPointerException();
        }
        this.outputProcessor = outputProcessor;
        this.documentContext = new DefaultDocumentContext();
        this.styleResolver = new DefaultStyleResolver();
    }

    public OutputProcessorMetaData getOutputMetaData() {
        return this.outputProcessor.getMetaData();
    }

    public OutputProcessor getOutputProcessor() {
        return this.outputProcessor;
    }

    public InputFeed getInputFeed() {
        if (this.inputFeed == null) {
            this.inputFeed = this.getOutputProcessor().createInputFeed(this);
        }
        return this.inputFeed;
    }

    protected abstract InputFeed createInputFeed();

    public DocumentContext getDocumentContext() {
        return this.documentContext;
    }

    public ResourceManager getResourceManager() {
        return this.documentContext.getResourceManager();
    }

    public void pageBreakEncountered(CSSValue pageName, PseudoPage[] pseudoPages) throws NormalizationException {
        this.getInputFeed().handlePageBreakEncountered(pageName, pseudoPages);
    }

    public boolean isPagebreakEncountered() {
        return this.getInputFeed().isPagebreakEncountered();
    }

    public Normalizer getNormalizer() {
        return this.getInputFeed().getCurrentNormalizer();
    }

    public StyleResolver getStyleResolver() {
        return this.styleResolver;
    }

    protected static abstract class AbstractLayoutProcessState
    implements LayoutProcessState {
        private State inputFeedState;
        private DocumentContext documentContext;
        private State styleResolver;

        protected AbstractLayoutProcessState(AbstractLayoutProcess lp) throws StateException {
            if (lp.styleResolver != null) {
                this.styleResolver = lp.styleResolver.saveState();
            }
            this.documentContext = lp.documentContext;
            if (lp.inputFeed != null) {
                this.inputFeedState = lp.inputFeed.saveState();
            }
        }

        protected AbstractLayoutProcess restore(OutputProcessor outputProcessor, AbstractLayoutProcess layoutProcess) throws StateException {
            layoutProcess.documentContext = this.documentContext;
            if (this.styleResolver != null) {
                layoutProcess.styleResolver = (StyleResolver)this.styleResolver.restore(layoutProcess);
            }
            if (this.inputFeedState != null) {
                layoutProcess.inputFeed = (InputFeed)this.inputFeedState.restore(layoutProcess);
            }
            return layoutProcess;
        }
    }
}

