/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: type_traits.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:32:46 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef UDM_TYPE_TRAITS_HXX
#define UDM_TYPE_TRAITS_HXX



// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
	// PARAMETERS
#include <cosv/template/tplutil.hxx>

namespace udm
{

class Data;

/// Has to be specialised and implemented for each relevant type.
template<class SRC, class RESULT>
RESULT
convert_value_src_2_udm( const SRC & i_rSrc );



template <class XY>
class type_traits
{
  public:
    static const type_traits<XY> &
                        get_();

    DYN Data &          create_data() const
                            { return do_CreateData(); }
    void                dispose_data(
                            DYN Data &          let_drData2Release ) const;

    void                connect_original(
                            Data &              o_rData,
                            const XY &          i_rOriginal ) const
                            { do_ConnectOriginal(o_rData, i_rOriginal); }
    DYN XY *            create_object() const
                            { do_CreateObject(); }

    DYN Data &          create_data_for(
                            const XY &          io_rOriginal ) const;
  private:
    virtual DYN Data &  do_CreateData() const = 0;
    virtual void        do_ConnectOriginal(
                            Data &              o_rData,
                            const XY &          i_rOriginal ) const = 0;
    virtual DYN XY *    do_CreateObject() const = 0;
};

template <class XY>
inline DYN Data &
type_traits<XY>::create_data_for( const XY & io_rOriginal ) const
{
    Data &  ret = create_data();
    connect_original(ret, io_rOriginal);
    return ret;
}


/** Has to be specialized and implemented
    for each yet unknown type accordingly.
*/
template <class XY>
DYN type_traits<XY> &   create_traits(
                            csv::Type2Type<XY> );


template <class XY>
const type_traits<XY> &
type_traits<XY>::get_()
{
 	static const type_traits<XY> &
        rSingleton = create_traits( csv::Type2Type<XY>() );
    return rSingleton;
}


}   // namespace udm


#endif


