/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sphere3d.hxx,v $
 *
 *  $Revision: 1.11 $
 *
 *  last change: $Author: ihi $ $Date: 2006/11/14 12:44:23 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _E3D_SPHERE3D_HXX
#define _E3D_SPHERE3D_HXX

#ifndef _E3D_OBJ3D_HXX
#include <svx/obj3d.hxx>
#endif

#ifndef INCLUDED_SVXDLLAPI_H
#include "svx/svxdllapi.h"
#endif

/*************************************************************************
|*
|* Kugelobjekt mit Durchmesser r3DSize; Anzahl der Flaechen wird durch
|* die horizontale und vertikale Segmentanzahl vorgegeben
|*
\************************************************************************/

class SVX_DLLPUBLIC E3dSphereObj : public E3dCompoundObject
{
	virtual sdr::properties::BaseProperties* CreateObjectSpecificProperties();

	basegfx::B3DPoint					aCenter;
	basegfx::B3DVector				aSize;

protected:
	void SetDefaultAttributes(E3dDefaultAttributes& rDefault);

public:
	TYPEINFO();
	E3dSphereObj(E3dDefaultAttributes& rDefault, const basegfx::B3DPoint& rCenter, const basegfx::B3DVector& r3DSize);
	E3dSphereObj();

	// FG: Dieser Konstruktor wird nur von MakeObject aus der 3d-Objectfactory beim
	//     Laden von Dokumenten mit Kugeln aufgerufen. Dieser Konstruktor ruft kein
	//     CreateSphere auf, er erzeugt also keine Kugel.
	E3dSphereObj(int dummy);

	// HorizontalSegments:
	sal_uInt32 GetHorizontalSegments() const 
		{ return ((const Svx3DHorizontalSegmentsItem&)GetObjectItemSet().Get(SDRATTR_3DOBJ_HORZ_SEGS)).GetValue(); }

	// VerticalSegments:
	sal_uInt32 GetVerticalSegments() const 
		{ return ((const Svx3DVerticalSegmentsItem&)GetObjectItemSet().Get(SDRATTR_3DOBJ_VERT_SEGS)).GetValue(); }

	virtual UINT16 GetObjIdentifier() const;
	virtual SdrObject* DoConvertToPolyObj(BOOL bBezier) const;

	virtual void operator=(const SdrObject&);

	void ReSegment(sal_uInt32 nHorzSegments, sal_uInt32 nVertSegments);
	const basegfx::B3DPoint& Center() const { return aCenter; }
	const basegfx::B3DVector& Size() const { return aSize; }

	// Geometrieerzeugung
	virtual void CreateGeometry();

	// Give out simple line geometry
	virtual basegfx::B3DPolyPolygon Get3DLineGeometry() const;

	// Lokale Parameter setzen mit Geometrieneuerzeugung
	void SetCenter(const basegfx::B3DPoint& rNew);
	void SetSize(const basegfx::B3DVector& rNew);

	// TakeObjName...() ist fuer die Anzeige in der UI, z.B. "3 Rahmen selektiert".
	virtual void TakeObjNameSingul(String& rName) const;
	virtual void TakeObjNamePlural(String& rName) const;
};

#endif			// _E3D_SPHERE3D_HXX
