/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: fcontnr.hxx,v $
 *
 *  $Revision: 1.12.210.1 $
 *
 *  last change: $Author: rt $ $Date: 2007/01/19 16:47:33 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SFX_FCONTNR_HXX
#define _SFX_FCONTNR_HXX

#ifndef _SAL_CONFIG_H_
#include "sal/config.h"
#endif

#ifndef INCLUDED_SFX2_DLLAPI_H
#include "sfx2/dllapi.h"
#endif

#ifndef _SAL_TYPES_H_
#include "sal/types.h"
#endif
#include <com/sun/star/uno/Sequence.hxx>
#include <com/sun/star/beans/NamedValue.hpp>
#ifndef _COM_SUN_STAR_CONTAINER_XNAMEACCESS_HPP_
#include <com/sun/star/container/XNameAccess.hpp>
#endif

#ifndef _SFXPOOLITEM_HXX //autogen
#include <svtools/poolitem.hxx>
#endif
#ifndef _WINDOW_HXX //autogen
#include <vcl/window.hxx>
#endif

#include <sfx2/docfilt.hxx>
#include <sfx2/sfxdefs.hxx>

class Window;
class SfxFilter;
class SfxFilterArr_Impl;
class SfxObjectFacArr_Impl;
class SfxObjectFactory;
class SfxMedium;
class SfxFilterContainer_Impl;
class SfxFrame;

//#define SFX_FILTER_CONTAINER_FACTORY 1
typedef USHORT SfxFilterContainerFlags;

class SfxRefItem : public SfxPoolItem
{
	SvRefBaseRef aRef;
public:
	virtual SfxPoolItem*	 Clone( SfxItemPool* = 0 ) const
	{ 	return new SfxRefItem( *this ); }
	virtual int 			 operator==( const SfxPoolItem& rL) const
	{   return ((SfxRefItem&)rL).aRef == aRef; }
	SfxRefItem( USHORT nWhichId, const SvRefBaseRef& rValue ) : SfxPoolItem( nWhichId )
	{   aRef = rValue; }
	const SvRefBaseRef&      GetValue() const { return aRef; }

};

class SfxFrameWindow
{
	Window*		pWindow;
public:
				SfxFrameWindow( Window *pWin )
				 : pWindow( pWin )
				{}

	virtual		~SfxFrameWindow()
				{ delete pWindow; }
	Window*		GetWindow() const
				{ return pWindow; }
	void		SetWindow( Window *pWin )
				{ pWindow = pWin; }
};

class SfxFrameWindowFactory
{
	typedef SfxFrameWindow* (*FactoryFunc)( SfxFrame* pParent, const String& rName );
	FactoryFunc pFunc;
	String aName;
public:
	SfxFrameWindowFactory( FactoryFunc pFuncP, String aNameP );
	String GetURLWildCard() { return aName; }
	FactoryFunc GetFactory() { return pFunc; }
};

typedef ULONG (*SfxDetectFilter)( SfxMedium& rMedium, const SfxFilter **, SfxFilterFlags nMust, SfxFilterFlags nDont );

class SFX2_DLLPUBLIC SfxFilterContainer
{
	SfxFilterContainer_Impl *pImpl;

public:
						SfxFilterContainer( const String& rName );
						~SfxFilterContainer();

//						SfxFilterContainerFlags GetFlags() const;
//	void 				SetFlags( SfxFilterContainerFlags eFlags );

	const String   		GetName() const;

    const SfxFilter* 	GetAnyFilter( SfxFilterFlags nMust = SFX_FILTER_IMPORT, SfxFilterFlags nDont = SFX_FILTER_NOTINSTALLED ) const;
	const SfxFilter* 	GetFilter4Mime( const String& rMime, SfxFilterFlags nMust = SFX_FILTER_IMPORT, SfxFilterFlags nDont = SFX_FILTER_NOTINSTALLED ) const;
	const SfxFilter* 	GetFilter4ClipBoardId( sal_uInt32 nId, SfxFilterFlags nMust = SFX_FILTER_IMPORT, SfxFilterFlags nDont = SFX_FILTER_NOTINSTALLED ) const;
	const SfxFilter* 	GetFilter4EA( const String& rEA, SfxFilterFlags nMust = SFX_FILTER_IMPORT, SfxFilterFlags nDont = SFX_FILTER_NOTINSTALLED ) const;
	const SfxFilter* 	GetFilter4Extension( const String& rExt, SfxFilterFlags nMust = SFX_FILTER_IMPORT, SfxFilterFlags nDont = SFX_FILTER_NOTINSTALLED ) const;
	const SfxFilter* 	GetFilter4FilterName( const String& rName, SfxFilterFlags nMust = 0, SfxFilterFlags nDont = SFX_FILTER_NOTINSTALLED ) const;
	const SfxFilter* 	GetFilter4UIName( const String& rName, SfxFilterFlags nMust = 0, SfxFilterFlags nDont = SFX_FILTER_NOTINSTALLED ) const;

#if 0 // _SOLAR__PRIVATE
	SAL_DLLPRIVATE static void ReadFilters_Impl( BOOL bUpdate=FALSE );
	SAL_DLLPRIVATE static void ReadSingleFilter_Impl( const ::rtl::OUString& rName,
    						const ::com::sun::star::uno::Reference< ::com::sun::star::container::XNameAccess >& xTypeCFG,
							const ::com::sun::star::uno::Reference< ::com::sun::star::container::XNameAccess >& xFilterCFG,
							BOOL bUpdate );
	SAL_DLLPRIVATE static const SfxFilter* GetDefaultFilter_Impl( const String& );
#endif
};

class SfxFilterMatcher_Impl;

class SFX2_DLLPUBLIC SfxFilterMatcher
{
	friend class SfxFilterMatcherIter;
	SfxFilterMatcher_Impl *pImpl;
public:
						SfxFilterMatcher( const String& rFact );
						SfxFilterMatcher();
						~SfxFilterMatcher();

#if 0 // _SOLAR__PRIVATE
	SAL_DLLPRIVATE static BOOL IsFilterInstalled_Impl( const SfxFilter* pFilter );
	DECL_DLLPRIVATE_STATIC_LINK( SfxFilterMatcher, MaybeFileHdl_Impl, String* );
#endif

	sal_uInt32               GuessFilterIgnoringContent( SfxMedium& rMedium, const SfxFilter **, SfxFilterFlags nMust = SFX_FILTER_IMPORT, SfxFilterFlags nDont = SFX_FILTER_NOTINSTALLED ) const;
	sal_uInt32               GuessFilter( SfxMedium& rMedium, const SfxFilter **, SfxFilterFlags nMust = SFX_FILTER_IMPORT, SfxFilterFlags nDont = SFX_FILTER_NOTINSTALLED ) const;
	sal_uInt32               GuessFilterControlDefaultUI( SfxMedium& rMedium, const SfxFilter **, SfxFilterFlags nMust = SFX_FILTER_IMPORT, SfxFilterFlags nDont = SFX_FILTER_NOTINSTALLED, sal_Bool bDefUI = sal_True ) const;
	sal_uInt32               DetectFilter( SfxMedium& rMedium, const SfxFilter **, BOOL bPlugIn, BOOL bAPI = FALSE ) const;

	const SfxFilter*	GetFilter4Mime( const String& rMime, SfxFilterFlags nMust = SFX_FILTER_IMPORT, SfxFilterFlags nDont = SFX_FILTER_NOTINSTALLED) const;
	const SfxFilter*    GetFilter4ClipBoardId( sal_uInt32 nId, SfxFilterFlags nMust = SFX_FILTER_IMPORT, SfxFilterFlags nDont = SFX_FILTER_NOTINSTALLED ) const;
	const SfxFilter*    GetFilter4EA( const String& rEA, SfxFilterFlags nMust = SFX_FILTER_IMPORT, SfxFilterFlags nDont = SFX_FILTER_NOTINSTALLED ) const;
	const SfxFilter*    GetFilter4Extension( const String& rExt, SfxFilterFlags nMust = SFX_FILTER_IMPORT, SfxFilterFlags nDont = SFX_FILTER_NOTINSTALLED ) const;
	const SfxFilter*    GetFilter4FilterName( const String& rName, SfxFilterFlags nMust = 0, SfxFilterFlags nDont = SFX_FILTER_NOTINSTALLED ) const;
	const SfxFilter*    GetFilter4UIName( const String& rName, SfxFilterFlags nMust = 0, SfxFilterFlags nDont = SFX_FILTER_NOTINSTALLED ) const;
	const SfxFilter* 	GetFilterForProps( const com::sun::star::uno::Sequence < ::com::sun::star::beans::NamedValue >& aSeq, SfxFilterFlags nMust = 0, SfxFilterFlags nDont = SFX_FILTER_NOTINSTALLED ) const;
    const SfxFilter* 	GetAnyFilter( SfxFilterFlags nMust=0, SfxFilterFlags nDont=SFX_FILTER_NOTINSTALLED ) const;
};

class SfxFilterContainer_Impl;
class SFX2_DLLPUBLIC SfxFilterMatcherIter
{
	SfxFilterFlags nOrMask;
	SfxFilterFlags nAndMask;
	USHORT nCurrent;
	const SfxFilterMatcher_Impl *pMatch;

#if 0 // _SOLAR__PRIVATE
	SAL_DLLPRIVATE const SfxFilter* Find_Impl();
#endif

public:
	SfxFilterMatcherIter( const SfxFilterMatcher* pMatchP, SfxFilterFlags nMask = 0, SfxFilterFlags nNotMask = SFX_FILTER_NOTINSTALLED );
	const SfxFilter* First();
	const SfxFilter* Next();
};

#endif
