/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM c:/OOo_Build/OOF680_m18/moz/wntmsci10.pro/misc/build/mozilla/intl/chardet/public/nsICharsetResolver.idl
 */

#ifndef __gen_nsICharsetResolver_h__
#define __gen_nsICharsetResolver_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIDocShell; /* forward declaration */

class nsIChannel; /* forward declaration */


/* starting interface:    nsICharsetResolver */
#define NS_ICHARSETRESOLVER_IID_STR "d143a084-b626-4614-845f-41f3ca43a674"

#define NS_ICHARSETRESOLVER_IID \
  {0xd143a084, 0xb626, 0x4614, \
    { 0x84, 0x5f, 0x41, 0xf3, 0xca, 0x43, 0xa6, 0x74 }}

class NS_NO_VTABLE nsICharsetResolver : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_ICHARSETRESOLVER_IID)

  /**
     * requestCharset
     * called to resolve the charset of an existing docshell.
     * If the charset cannot be resolved, but the implementation is
     * still curious what the final charset turned out to be, it can
     * set wantCharset to true.
     * If so, notifyResovedCharset will be called with the resulting
     * closure
     * 
     * @param docShell    the docshell the document is being loaded in
     * @param channel     the channel the document is coming in from
     * @param charsetSource a unique number which can be stored by the
     *                    caller to remember which resolver actually
     *                    resolved the charset.
     * @param wantCharset gets set to true if notifyResolvedCharset should be
     *                    called with the given closure object
     * @param closure     a resulting object which should be passed
     *                    to notifyResolvedCharset
     * @returns           the resolved charset, or the empty string if no
     *                    charset could be determined
     */
  /* ACString requestCharset (in nsIDocShell docShell, in nsIChannel channel, out long charsetSource, out boolean wantCharset, out nsISupports closure); */
  NS_IMETHOD RequestCharset(nsIDocShell *docShell, nsIChannel *channel, PRInt32 *charsetSource, PRBool *wantCharset, nsISupports **closure, nsACString & _retval) = 0;

  /**
     * notifyResolvedCharset
     *
     * some implementations may request that they be notified when the
     * charset is actually detected. 
     *
     * @param charset the detected charset
     * @param closure the closre returned by detectCharset() above
     */
  /* void notifyResolvedCharset (in ACString charset, in nsISupports closure); */
  NS_IMETHOD NotifyResolvedCharset(const nsACString & charset, nsISupports *closure) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSICHARSETRESOLVER \
  NS_IMETHOD RequestCharset(nsIDocShell *docShell, nsIChannel *channel, PRInt32 *charsetSource, PRBool *wantCharset, nsISupports **closure, nsACString & _retval); \
  NS_IMETHOD NotifyResolvedCharset(const nsACString & charset, nsISupports *closure); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSICHARSETRESOLVER(_to) \
  NS_IMETHOD RequestCharset(nsIDocShell *docShell, nsIChannel *channel, PRInt32 *charsetSource, PRBool *wantCharset, nsISupports **closure, nsACString & _retval) { return _to RequestCharset(docShell, channel, charsetSource, wantCharset, closure, _retval); } \
  NS_IMETHOD NotifyResolvedCharset(const nsACString & charset, nsISupports *closure) { return _to NotifyResolvedCharset(charset, closure); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSICHARSETRESOLVER(_to) \
  NS_IMETHOD RequestCharset(nsIDocShell *docShell, nsIChannel *channel, PRInt32 *charsetSource, PRBool *wantCharset, nsISupports **closure, nsACString & _retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->RequestCharset(docShell, channel, charsetSource, wantCharset, closure, _retval); } \
  NS_IMETHOD NotifyResolvedCharset(const nsACString & charset, nsISupports *closure) { return !_to ? NS_ERROR_NULL_POINTER : _to->NotifyResolvedCharset(charset, closure); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsCharsetResolver : public nsICharsetResolver
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSICHARSETRESOLVER

  nsCharsetResolver();

private:
  ~nsCharsetResolver();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsCharsetResolver, nsICharsetResolver)

nsCharsetResolver::nsCharsetResolver()
{
  /* member initializers and constructor code */
}

nsCharsetResolver::~nsCharsetResolver()
{
  /* destructor code */
}

/* ACString requestCharset (in nsIDocShell docShell, in nsIChannel channel, out long charsetSource, out boolean wantCharset, out nsISupports closure); */
NS_IMETHODIMP nsCharsetResolver::RequestCharset(nsIDocShell *docShell, nsIChannel *channel, PRInt32 *charsetSource, PRBool *wantCharset, nsISupports **closure, nsACString & _retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void notifyResolvedCharset (in ACString charset, in nsISupports closure); */
NS_IMETHODIMP nsCharsetResolver::NotifyResolvedCharset(const nsACString & charset, nsISupports *closure)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsICharsetResolver_h__ */
