/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.IllegalAccessibleComponentStateException;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.accessibility.XAccessibleImage;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.accessibility.XAccessibleValue;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.Locale;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.awt.Component;
import java.awt.IllegalComponentStateException;
import java.util.ArrayList;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import org.openoffice.java.accessibility.AccessibleActionImpl;
import org.openoffice.java.accessibility.AccessibleComponentImpl;
import org.openoffice.java.accessibility.AccessibleIconImpl;
import org.openoffice.java.accessibility.AccessibleObjectFactory;
import org.openoffice.java.accessibility.AccessibleRoleAdapter;
import org.openoffice.java.accessibility.AccessibleStateAdapter;
import org.openoffice.java.accessibility.AccessibleTextImpl;
import org.openoffice.java.accessibility.AccessibleValueImpl;
import org.openoffice.java.accessibility.DescendantManager;

public class List
extends DescendantManager
implements Accessible {
    protected List(XAccessible xAccessible, XAccessibleContext xAccessibleContext) {
        super(xAccessible, xAccessibleContext);
    }

    protected void setActiveDescendant(Accessible accessible) {
        Accessible accessible2 = this.activeDescendant;
        this.activeDescendant = accessible;
        this.firePropertyChange("AccessibleActiveDescendant", accessible2, accessible);
    }

    protected void setActiveDescendant(Object object) {
        ListItem listItem = null;
        try {
            XAccessible xAccessible;
            if (AnyConverter.isObject((Object)object) && (xAccessible = (XAccessible)AnyConverter.toObject((Type)AccessibleObjectFactory.XAccessibleType, (Object)object)) != null) {
                listItem = new ListItem(xAccessible);
            }
            this.setActiveDescendant(listItem);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void add(XAccessible xAccessible) {
        if (xAccessible != null) {
            ListItem listItem = new ListItem(xAccessible);
            this.firePropertyChange("AccessibleChild", null, listItem.getAccessibleContext());
        }
    }

    protected void remove(XAccessible xAccessible) {
        if (xAccessible != null) {
            ListItem listItem = new ListItem(xAccessible);
            this.firePropertyChange("AccessibleChild", listItem.getAccessibleContext(), null);
        }
    }

    protected void add(Object object) {
        try {
            this.add((XAccessible)AnyConverter.toObject((Type)AccessibleObjectFactory.XAccessibleType, (Object)object));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void remove(Object object) {
        try {
            this.remove((XAccessible)AnyConverter.toObject((Type)AccessibleObjectFactory.XAccessibleType, (Object)object));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected XAccessibleEventListener createEventListener() {
        return new AccessibleListListener();
    }

    public AccessibleContext createAccessibleContext() {
        return new AccessibleList();
    }

    class ListItem
    extends Component
    implements Accessible {
        protected XAccessible unoAccessible;
        AccessibleContext accessibleContext = null;

        public ListItem(XAccessible xAccessible) {
            this.unoAccessible = xAccessible;
        }

        public Object[] create(Object[] objectArray) {
            try {
                ArrayList<ListItem> arrayList = new ArrayList<ListItem>(objectArray.length);
                for (int i = 0; i < objectArray.length; ++i) {
                    XAccessible xAccessible = (XAccessible)UnoRuntime.queryInterface(XAccessible.class, (Object)objectArray[i]);
                    if (xAccessible == null) continue;
                    arrayList.add(new ListItem(xAccessible));
                }
                arrayList.trimToSize();
                return arrayList.toArray();
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                try {
                    AccessibleListItem accessibleListItem;
                    XAccessibleContext xAccessibleContext = this.unoAccessible.getAccessibleContext();
                    if (xAccessibleContext != null && (accessibleListItem = new AccessibleListItem(xAccessibleContext)) != null) {
                        accessibleListItem.setAccessibleParent(List.this);
                        this.accessibleContext = accessibleListItem;
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            return this.accessibleContext;
        }

        protected class AccessibleListItem
        extends AccessibleContext {
            XAccessibleContext unoAccessibleContext;

            public AccessibleListItem(XAccessibleContext xAccessibleContext) {
                this.unoAccessibleContext = xAccessibleContext;
            }

            public String getAccessibleName() {
                try {
                    return this.unoAccessibleContext.getAccessibleName();
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }

            public void setAccessibleName(String string) {
            }

            public String getAccessibleDescription() {
                try {
                    return this.unoAccessibleContext.getAccessibleDescription();
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }

            public void setAccessibleDescription(String string) {
            }

            public AccessibleRole getAccessibleRole() {
                try {
                    AccessibleRole accessibleRole = AccessibleRoleAdapter.getAccessibleRole(this.unoAccessibleContext.getAccessibleRole());
                    return accessibleRole != null ? accessibleRole : AccessibleRole.LABEL;
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }

            public java.util.Locale getLocale() throws IllegalComponentStateException {
                try {
                    Locale locale = this.unoAccessibleContext.getLocale();
                    return new java.util.Locale(locale.Language, locale.Country);
                }
                catch (IllegalAccessibleComponentStateException illegalAccessibleComponentStateException) {
                    throw new IllegalComponentStateException(illegalAccessibleComponentStateException.getMessage());
                }
                catch (RuntimeException runtimeException) {
                    return List.this.getLocale();
                }
            }

            public int getAccessibleIndexInParent() {
                try {
                    return this.unoAccessibleContext.getAccessibleIndexInParent();
                }
                catch (RuntimeException runtimeException) {
                    return -1;
                }
            }

            public int getAccessibleChildrenCount() {
                try {
                    return this.unoAccessibleContext.getAccessibleChildCount();
                }
                catch (RuntimeException runtimeException) {
                    return 0;
                }
            }

            public Accessible getAccessibleChild(int n) {
                Accessible accessible = null;
                try {
                    XAccessible xAccessible = this.unoAccessibleContext.getAccessibleChild(n);
                    Accessible accessible2 = List.this.activeDescendant;
                    if (accessible2 instanceof ListItem && ((ListItem)accessible2).unoAccessible.equals(xAccessible)) {
                        accessible = accessible2;
                    } else if (xAccessible != null) {
                        accessible = new ListItem(xAccessible);
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                return accessible;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                try {
                    return AccessibleStateAdapter.getAccessibleStateSet(ListItem.this, this.unoAccessibleContext.getAccessibleStateSet());
                }
                catch (RuntimeException runtimeException) {
                    return AccessibleStateAdapter.getDefunctStateSet();
                }
            }

            public AccessibleComponent getAccessibleComponent() {
                try {
                    XAccessibleComponent xAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)this.unoAccessibleContext);
                    return xAccessibleComponent != null ? new AccessibleComponentImpl(xAccessibleComponent) : null;
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }

            public AccessibleAction getAccessibleAction() {
                try {
                    XAccessibleAction xAccessibleAction = (XAccessibleAction)UnoRuntime.queryInterface(XAccessibleAction.class, (Object)this.unoAccessibleContext);
                    return xAccessibleAction != null ? new AccessibleActionImpl(xAccessibleAction) : null;
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }

            public AccessibleText getAccessibleText() {
                if (List.this.disposed) {
                    return null;
                }
                try {
                    XAccessibleText xAccessibleText = (XAccessibleText)UnoRuntime.queryInterface(XAccessibleText.class, (Object)this.unoAccessibleContext);
                    return xAccessibleText != null ? new AccessibleTextImpl(xAccessibleText) : null;
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }

            public AccessibleValue getAccessibleValue() {
                try {
                    XAccessibleValue xAccessibleValue = (XAccessibleValue)UnoRuntime.queryInterface(XAccessibleValue.class, (Object)this.unoAccessibleContext);
                    return xAccessibleValue != null ? new AccessibleValueImpl(xAccessibleValue) : null;
                }
                catch (RuntimeException runtimeException) {
                    return null;
                }
            }

            public AccessibleIcon[] getAccessibleIcon() {
                try {
                    XAccessibleImage xAccessibleImage = (XAccessibleImage)UnoRuntime.queryInterface(XAccessibleImage.class, (Object)this.unoAccessibleContext);
                    if (xAccessibleImage != null) {
                        AccessibleIcon[] accessibleIconArray = new AccessibleIcon[]{new AccessibleIconImpl(xAccessibleImage)};
                        return accessibleIconArray;
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                return null;
            }
        }
    }

    protected class AccessibleList
    extends DescendantManager.AccessibleDescendantManager {
        protected AccessibleList() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST;
        }

        public Accessible getAccessibleChild(int n) {
            Accessible accessible = null;
            try {
                XAccessible xAccessible = List.this.unoAccessibleContext.getAccessibleChild(n);
                if (xAccessible != null) {
                    Accessible accessible2 = List.this.activeDescendant;
                    accessible = accessible2 instanceof ListItem && xAccessible.equals(((ListItem)accessible2).unoAccessible) ? accessible2 : new ListItem(xAccessible);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return accessible;
        }

        public Accessible getAccessibleSelection(int n) {
            Accessible accessible = null;
            try {
                XAccessible xAccessible = List.this.unoAccessibleSelection.getSelectedAccessibleChild(n);
                if (xAccessible != null) {
                    Accessible accessible2 = List.this.activeDescendant;
                    accessible = accessible2 instanceof ListItem && xAccessible.equals(((ListItem)accessible2).unoAccessible) ? accessible2 : new ListItem(xAccessible);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return accessible;
        }
    }

    protected class AccessibleListListener
    extends DescendantManager.AccessibleDescendantManagerListener {
        protected AccessibleListListener() {
        }

        public void notifyEvent(AccessibleEventObject accessibleEventObject) {
            switch (accessibleEventObject.EventId) {
                case 5: {
                    List.this.setActiveDescendant(accessibleEventObject.NewValue);
                    break;
                }
                case 7: {
                    if (AnyConverter.isObject((Object)accessibleEventObject.OldValue)) {
                        List.this.remove(accessibleEventObject.OldValue);
                    }
                    if (!AnyConverter.isObject((Object)accessibleEventObject.NewValue)) break;
                    List.this.add(accessibleEventObject.NewValue);
                    break;
                }
                case 8: {
                    break;
                }
                default: {
                    super.notifyEvent(accessibleEventObject);
                }
            }
        }
    }
}

