/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.sun.star.awt.Rectangle;
import com.sun.star.awt.WindowClass;
import com.sun.star.awt.WindowDescriptor;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XTopWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XNameReplace;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XModel;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import com.sun.star.util.XModifiable;
import com.sun.star.view.XViewSettingsSupplier;
import helper.ConfigHelper;
import java.util.Vector;
import lib.StatusException;
import util.utils;

public class DesktopTools {
    public static XComponentLoader getCLoader(XMultiServiceFactory xMultiServiceFactory) {
        XDesktop xDesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, DesktopTools.createDesktop(xMultiServiceFactory));
        XComponentLoader xComponentLoader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)xDesktop);
        return xComponentLoader;
    }

    public static Object createDesktop(XMultiServiceFactory xMultiServiceFactory) {
        Object object;
        try {
            object = xMultiServiceFactory.createInstance("com.sun.star.comp.framework.Desktop");
        }
        catch (com.sun.star.uno.Exception exception) {
            throw new java.lang.IllegalArgumentException("Desktop Service not available");
        }
        return object;
    }

    public static XEnumeration getAllComponents(XMultiServiceFactory xMultiServiceFactory) {
        XDesktop xDesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, DesktopTools.createDesktop(xMultiServiceFactory));
        return xDesktop.getComponents().createEnumeration();
    }

    public static XComponent getCurrentComponent(XMultiServiceFactory xMultiServiceFactory) {
        XDesktop xDesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, DesktopTools.createDesktop(xMultiServiceFactory));
        return xDesktop.getCurrentComponent();
    }

    public static Object[] getAllOpenDocuments(XMultiServiceFactory xMultiServiceFactory) {
        Vector<XComponent> vector = new Vector<XComponent>();
        XDesktop xDesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, DesktopTools.createDesktop(xMultiServiceFactory));
        XEnumeration xEnumeration = DesktopTools.getAllComponents(xMultiServiceFactory);
        while (xEnumeration.hasMoreElements()) {
            try {
                XComponent xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, xEnumeration.nextElement());
                if (DesktopTools.getDocumentType(xComponent) == null) continue;
                vector.add(xComponent);
            }
            catch (NoSuchElementException noSuchElementException) {
            }
            catch (WrappedTargetException wrappedTargetException) {}
        }
        return vector.toArray();
    }

    public static String getDocumentType(XComponent xComponent) {
        XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)xComponent);
        if (xServiceInfo == null) {
            return "";
        }
        if (xServiceInfo.supportsService("com.sun.star.sheet.SpreadsheetDocument")) {
            return "scalc";
        }
        if (xServiceInfo.supportsService("com.sun.star.text.TextDocument")) {
            return "swriter";
        }
        if (xServiceInfo.supportsService("com.sun.star.drawing.DrawingDocument")) {
            return "sdraw";
        }
        if (xServiceInfo.supportsService("com.sun.star.formula.FormulaProperties")) {
            return "smath";
        }
        return null;
    }

    public static XComponent openNewDoc(XMultiServiceFactory xMultiServiceFactory, String string, PropertyValue[] propertyValueArray) {
        XComponent xComponent = null;
        try {
            xComponent = DesktopTools.getCLoader(xMultiServiceFactory).loadComponentFromURL("private:factory/" + string, "_blank", 0, propertyValueArray);
        }
        catch (com.sun.star.uno.Exception exception) {
            throw new java.lang.IllegalArgumentException("Document could not be opened");
        }
        return xComponent;
    }

    public static XComponent loadDoc(XMultiServiceFactory xMultiServiceFactory, String string, PropertyValue[] propertyValueArray) {
        XComponent xComponent = null;
        if (propertyValueArray == null) {
            propertyValueArray = new PropertyValue[]{};
        }
        try {
            xComponent = DesktopTools.getCLoader(xMultiServiceFactory).loadComponentFromURL(string, "_blank", 0, propertyValueArray);
        }
        catch (com.sun.star.uno.Exception exception) {
            throw new java.lang.IllegalArgumentException("Document could not be loaded");
        }
        return xComponent;
    }

    public static void closeDoc(XInterface xInterface) {
        String string = System.getProperty("KeepDocument");
        if (string != null) {
            System.out.println("The property 'KeepDocument' is set and so the document won't be disposed");
            return;
        }
        XModifiable xModifiable = (XModifiable)UnoRuntime.queryInterface(XModifiable.class, (Object)xInterface);
        XCloseable xCloseable = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)xInterface);
        try {
            xModifiable.setModified(false);
            xCloseable.close(true);
        }
        catch (CloseVetoException closeVetoException) {
            System.out.println("Couldn't close document");
        }
        catch (DisposedException disposedException) {
            System.out.println("Couldn't close document");
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("Couldn't close document");
        }
        catch (PropertyVetoException propertyVetoException) {
            System.out.println("Couldn't close document");
        }
    }

    public static XWindowPeer createFloatingWindow(XMultiServiceFactory xMultiServiceFactory) throws StatusException {
        return DesktopTools.createFloatingWindow(xMultiServiceFactory, 500, 100, 400, 600);
    }

    public static XWindowPeer createFloatingWindow(XMultiServiceFactory xMultiServiceFactory, int n, int n2, int n3, int n4) throws StatusException {
        XInterface xInterface = null;
        try {
            xInterface = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.awt.Toolkit");
        }
        catch (com.sun.star.uno.Exception exception) {
            throw new StatusException("Couldn't get toolkit", exception);
        }
        XToolkit xToolkit = (XToolkit)UnoRuntime.queryInterface(XToolkit.class, (Object)xInterface);
        WindowDescriptor windowDescriptor = new WindowDescriptor();
        windowDescriptor.Type = WindowClass.TOP;
        windowDescriptor.WindowServiceName = "modelessdialog";
        windowDescriptor.ParentIndex = (short)-1;
        Rectangle rectangle = new Rectangle();
        rectangle.X = n;
        rectangle.Y = n2;
        rectangle.Width = n3;
        rectangle.Height = n4;
        windowDescriptor.Bounds = rectangle;
        windowDescriptor.WindowAttributes = 524528;
        XWindowPeer xWindowPeer = null;
        try {
            xWindowPeer = xToolkit.createWindow(windowDescriptor);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new StatusException("Could not create window", illegalArgumentException);
        }
        return xWindowPeer;
    }

    public static void zoomToEntirePage(XInterface xInterface) {
        try {
            XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xInterface);
            XController xController = xModel.getCurrentController();
            XViewSettingsSupplier xViewSettingsSupplier = (XViewSettingsSupplier)UnoRuntime.queryInterface(XViewSettingsSupplier.class, (Object)xController);
            XPropertySet xPropertySet = xViewSettingsSupplier.getViewSettings();
            XPropertySet xPropertySet2 = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xPropertySet);
            xPropertySet2.setPropertyValue("ZoomType", new Short(2));
            utils.shortWait(5000);
        }
        catch (Exception exception) {
            System.out.println("Could not zoom to entire page: " + exception.toString());
        }
    }

    public static void dockStylist(XMultiServiceFactory xMultiServiceFactory) {
        try {
            ConfigHelper configHelper = new ConfigHelper(xMultiServiceFactory, "org.openoffice.Office.Views", false);
            XNameReplace xNameReplace = configHelper.getOrInsertGroup("Windows", "5539");
            configHelper.updateGroupProperty("Windows", "5539", "WindowState", "952,180,244,349;1;0,0,0,0;");
            configHelper.insertOrUpdateExtensibleGroupProperty("Windows", "5539", "UserData", "Data", "V2,V,0,AL:(5,16,0/0/244/349,244;610)");
            configHelper.getOrInsertGroup("Windows", "SplitWindow2");
            configHelper.insertOrUpdateExtensibleGroupProperty("Windows", "SplitWindow2", "UserData", "UserItem", "V1,2,1,0,5539");
            configHelper.flush();
            configHelper = null;
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void bringWindowToFromt(XModel xModel) {
        XTopWindow xTopWindow = (XTopWindow)UnoRuntime.queryInterface(XTopWindow.class, (Object)xModel.getCurrentController().getFrame().getContainerWindow());
        xTopWindow.toFront();
    }
}

