/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xmlsearch.xml.qe;

import com.sun.xmlsearch.xml.qe.ConceptGroupGenerator;
import com.sun.xmlsearch.xml.qe.RoleFiller;

final class GeneratorHeap {
    private static final int InitSize = 128;
    private int _heapSize = 0;
    private ConceptGroupGenerator[] _heap = new ConceptGroupGenerator[128];
    private int _size = 128;
    private int _free = 0;

    public void reset() {
        this._free = 0;
    }

    public void addGenerator(ConceptGroupGenerator conceptGroupGenerator) {
        if (this._free == this._size) {
            ConceptGroupGenerator[] conceptGroupGeneratorArray = new ConceptGroupGenerator[this._size *= 2];
            System.arraycopy(this._heap, 0, conceptGroupGeneratorArray, 0, this._free);
            this._heap = conceptGroupGeneratorArray;
        }
        this._heap[this._free++] = conceptGroupGenerator;
    }

    private void buildHeap() {
        for (int i = this._heapSize / 2; i >= 0; --i) {
            this.heapify(i);
        }
    }

    private void heapify(int n) {
        while (true) {
            int n2;
            int n3;
            int n4;
            int n5 = n4 = (n3 = (n2 = n + 1 << 1) - 1) < this._heapSize && this._heap[n3].position() < this._heap[n].position() ? n3 : n;
            if (n2 < this._heapSize && this._heap[n2].position() < this._heap[n4].position()) {
                n4 = n2;
            }
            if (n4 == n) break;
            ConceptGroupGenerator conceptGroupGenerator = this._heap[n4];
            this._heap[n4] = this._heap[n];
            this._heap[n] = conceptGroupGenerator;
            n = n4;
        }
    }

    public boolean start(RoleFiller[] roleFillerArray) throws Exception {
        this._heapSize = this._free;
        if (this._heapSize > 0) {
            for (int i = 0; i < this._free; ++i) {
                this._heap[i].next();
            }
            this.buildHeap();
            this._heap[0].generateFillers(roleFillerArray);
            return true;
        }
        return false;
    }

    public boolean start() throws Exception {
        this._heapSize = this._free;
        if (this._heapSize > 0) {
            for (int i = 0; i < this._free; ++i) {
                this._heap[i].step();
            }
            this.buildHeap();
            return true;
        }
        return false;
    }

    public boolean next(RoleFiller[] roleFillerArray) throws Exception {
        if (this._heapSize > 0) {
            if (!this._heap[0].next()) {
                if (this._heapSize > 1) {
                    this._heap[0] = this._heap[--this._heapSize];
                } else {
                    this._heapSize = 0;
                    return false;
                }
            }
            this.heapify(0);
            this._heap[0].generateFillers(roleFillerArray);
            return true;
        }
        return false;
    }

    public boolean next() throws Exception {
        if (this._heapSize > 0) {
            if (!this._heap[0].step()) {
                if (this._heapSize > 1) {
                    this._heap[0] = this._heap[--this._heapSize];
                } else {
                    this._heapSize = 0;
                    return false;
                }
            }
            this.heapify(0);
            return true;
        }
        return false;
    }

    public int position() {
        return this._heap[0].position();
    }

    public int getConcept() throws Exception {
        return this._heap[0].getConcept();
    }
}

