/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxw.aportisdoc;

import java.io.IOException;
import org.openoffice.xmerge.ConvertData;
import org.openoffice.xmerge.ConvertException;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.DocumentSerializer;
import org.openoffice.xmerge.converter.palm.PalmDocument;
import org.openoffice.xmerge.converter.palm.Record;
import org.openoffice.xmerge.converter.xml.OfficeConstants;
import org.openoffice.xmerge.converter.xml.sxw.SxwDocument;
import org.openoffice.xmerge.converter.xml.sxw.aportisdoc.DocConstants;
import org.openoffice.xmerge.converter.xml.sxw.aportisdoc.DocEncoder;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.XmlUtil;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DocumentSerializerImpl
implements OfficeConstants,
DocConstants,
DocumentSerializer {
    private DocEncoder encoder = null;
    private SxwDocument sxwDoc = null;

    public DocumentSerializerImpl(Document document) {
        this.sxwDoc = (SxwDocument)document;
    }

    public ConvertData serialize() throws ConvertException, IOException {
        Record[] recordArray;
        String string = this.sxwDoc.getName();
        org.w3c.dom.Document document = this.sxwDoc.getContentDOM();
        this.encoder = new DocEncoder();
        NodeList nodeList = document.getElementsByTagName("office:body");
        int n = nodeList.getLength();
        if (n > 0) {
            recordArray = nodeList.item(0);
            this.traverseBody((Node)recordArray);
        }
        recordArray = this.encoder.getRecords();
        ConvertData convertData = new ConvertData();
        PalmDocument palmDocument = new PalmDocument(string, DocConstants.CREATOR_ID, DocConstants.TYPE_ID, 0, 8, recordArray);
        convertData.addDocument((Document)palmDocument);
        return convertData;
    }

    private void traverseBody(Node node) throws IOException {
        this.log("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.log("<AportisDOC>");
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1) continue;
                String string = node2.getNodeName();
                if (string.equals("text:p") || string.equals("text:h")) {
                    this.traverseParagraph(node2);
                    continue;
                }
                if (string.equals("text:unordered-list")) {
                    this.traverseList(node2);
                    continue;
                }
                if (string.equals("text:ordered-list")) {
                    this.traverseList(node2);
                    continue;
                }
                this.log("<OTHERS " + XmlUtil.getNodeInfo((Node)node2) + " />");
            }
        }
        this.log("</AportisDOC>");
    }

    private void traverseParagraph(Node node) throws IOException {
        this.log("<PARA>");
        this.traverseParaContents(node);
        this.encoder.addText('\n');
        this.log("</PARA>");
    }

    private void traverseParaContents(Node node) throws IOException {
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            block5: for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                short s = node2.getNodeType();
                switch (s) {
                    case 3: {
                        String string = node2.getNodeValue();
                        if (string.length() > 0) {
                            this.encoder.addText(string);
                        }
                        this.log("<TEXT>");
                        this.log(string);
                        this.log("</TEXT>");
                        continue block5;
                    }
                    case 1: {
                        this.traverseParaElem(node2);
                        continue block5;
                    }
                    case 5: {
                        this.log("<ENTITY_REFERENCE>");
                        this.traverseParaContents(node2);
                        this.log("<ENTITY_REFERENCE/>");
                        continue block5;
                    }
                    default: {
                        this.log("<OTHERS " + XmlUtil.getNodeInfo((Node)node) + " />");
                    }
                }
            }
        }
    }

    private void traverseParaElem(Node node) throws IOException {
        String string = node.getNodeName();
        if (string.equals("text:s")) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = namedNodeMap.getNamedItem("text:c");
            StringBuffer stringBuffer = new StringBuffer(32);
            int n = 1;
            if (node2 != null) {
                try {
                    String string2 = node2.getNodeValue();
                    n = Integer.parseInt(string2.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IOException(numberFormatException.getMessage());
                }
            }
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(' ');
            }
            this.encoder.addText(stringBuffer.toString());
            this.log("<SPACE count=\"" + n + "\" />");
        } else if (string.equals("text:tab-stop")) {
            this.encoder.addText('\t');
            this.log("<TAB/>");
        } else if (string.equals("text:line-break")) {
            this.log("skipped <LINE-BREAK/>");
        } else if (string.equals("text:span")) {
            this.log("<SPAN>");
            this.traverseParaContents(node);
            this.log("</SPAN>");
        } else if (string.equals("text:a")) {
            this.log("<HYPERLINK>");
            this.traverseParaContents(node);
            this.log("<HYPERLINK/>");
        } else if (string.equals("text:bookmark") || string.equals("text:bookmark-start")) {
            this.log("<BOOKMARK/>");
        } else if (string.equals("text:variable-set") || string.equals("text:variable-get") || string.equals("text:expression") || string.equals("text:user-field-get") || string.equals("text:page-variable-get") || string.equals("text:sequence") || string.equals("text:variable-input") || string.equals("text:time") || string.equals("text:page-count") || string.equals("text:page-number") || string.equals("text:subject") || string.equals("text:title") || string.equals("text:creation-time") || string.equals("text:date") || string.equals("text:text-input") || string.equals("text:author-initials")) {
            this.log("<FIELD>");
            this.traverseParaContents(node);
            this.log("</FIELD>");
        } else if (string.startsWith("text:")) {
            this.log("<Unknown text Field>");
            this.traverseParaContents(node);
            this.log("</Unknown text Field>");
        } else {
            this.log("<OTHERS " + XmlUtil.getNodeInfo((Node)node) + " />");
        }
    }

    private void traverseList(Node node) throws IOException {
        this.log("<LIST>");
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1) continue;
                String string = node2.getNodeName();
                if (string.equals("text:list-item")) {
                    this.traverseListItem(node2);
                    continue;
                }
                if (string.equals("text:list-header")) {
                    this.traverseListHeader(node2);
                    continue;
                }
                this.log("<INVALID-XML-BUG " + XmlUtil.getNodeInfo((Node)node2) + " />");
            }
        }
        this.log("</LIST>");
    }

    private void traverseListHeader(Node node) throws IOException {
        this.log("<LIST-HEADER>");
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1) continue;
                String string = node2.getNodeName();
                if (string.equals("text:p")) {
                    this.traverseParagraph(node2);
                    continue;
                }
                this.log("<INVALID-XML-BUG " + XmlUtil.getNodeInfo((Node)node2) + " />");
            }
        }
        this.log("</LIST-HEADER>");
    }

    private void traverseListItem(Node node) throws IOException {
        this.log("<LIST-ITEM>");
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1) continue;
                String string = node2.getNodeName();
                if (string.equals("text:p")) {
                    this.traverseParagraph(node2);
                    continue;
                }
                if (string.equals("text:unordered-list")) {
                    this.traverseList(node2);
                    continue;
                }
                if (string.equals("text:ordered-list")) {
                    this.traverseList(node2);
                    continue;
                }
                this.log("<INVALID-XML-BUG " + XmlUtil.getNodeInfo((Node)node2) + " />");
            }
        }
        this.log("</LIST-ITEM>");
    }

    private void log(String string) {
        Debug.log((int)4, (String)string);
    }
}

