/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.DToA;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

final class NativeNumber
extends IdScriptable {
    private static final int MAX_PRECISION = 100;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_valueOf = 3;
    private static final int Id_toLocaleString = 4;
    private static final int Id_toFixed = 5;
    private static final int Id_toExponential = 6;
    private static final int Id_toPrecision = 7;
    private static final int MAX_PROTOTYPE_ID = 7;
    private static final double defaultValue = 0.0;
    private double doubleValue;
    private boolean prototypeFlag;

    static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeNumber nativeNumber = new NativeNumber();
        nativeNumber.prototypeFlag = true;
        nativeNumber.addAsPrototype(7, context, scriptable, bl);
    }

    private NativeNumber() {
        this.doubleValue = 0.0;
    }

    private NativeNumber(double d) {
        this.doubleValue = d;
    }

    public String getClassName() {
        return "Number";
    }

    protected void fillConstructorProperties(Context context, IdFunction idFunction, boolean bl) {
        idFunction.defineProperty("NaN", this.wrap_double(ScriptRuntime.NaN), 7);
        idFunction.defineProperty("POSITIVE_INFINITY", this.wrap_double(Double.POSITIVE_INFINITY), 7);
        idFunction.defineProperty("NEGATIVE_INFINITY", this.wrap_double(Double.NEGATIVE_INFINITY), 7);
        idFunction.defineProperty("MAX_VALUE", this.wrap_double(Double.MAX_VALUE), 7);
        idFunction.defineProperty("MIN_VALUE", this.wrap_double(Double.MIN_VALUE), 7);
        super.fillConstructorProperties(context, idFunction, bl);
    }

    public int methodArity(int n) {
        if (this.prototypeFlag) {
            switch (n) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 0;
                }
                case 4: {
                    return 1;
                }
                case 5: {
                    return 1;
                }
                case 6: {
                    return 1;
                }
                case 7: {
                    return 1;
                }
            }
        }
        return super.methodArity(n);
    }

    public Object execMethod(int n, IdFunction idFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        if (this.prototypeFlag) {
            switch (n) {
                case 1: {
                    return this.jsConstructor(objectArray, scriptable2 == null);
                }
                case 2: {
                    return this.realThis(scriptable2, idFunction).js_toString(NativeNumber.toBase(objectArray, 0));
                }
                case 3: {
                    return this.wrap_double(this.realThis((Scriptable)scriptable2, (IdFunction)idFunction).doubleValue);
                }
                case 4: {
                    return this.realThis(scriptable2, idFunction).js_toLocaleString(NativeNumber.toBase(objectArray, 0));
                }
                case 5: {
                    return this.realThis(scriptable2, idFunction).js_toFixed(context, objectArray);
                }
                case 6: {
                    return this.realThis(scriptable2, idFunction).js_toExponential(context, objectArray);
                }
                case 7: {
                    return this.realThis(scriptable2, idFunction).js_toPrecision(context, objectArray);
                }
            }
        }
        return super.execMethod(n, idFunction, context, scriptable, scriptable2, objectArray);
    }

    private NativeNumber realThis(Scriptable scriptable, IdFunction idFunction) {
        while (!(scriptable instanceof NativeNumber)) {
            scriptable = this.nextInstanceCheck(scriptable, idFunction, true);
        }
        return (NativeNumber)scriptable;
    }

    private static int toBase(Object[] objectArray, int n) {
        return n < objectArray.length ? ScriptRuntime.toInt32(objectArray[n]) : 10;
    }

    private Object jsConstructor(Object[] objectArray, boolean bl) {
        double d;
        double d2 = d = objectArray.length >= 1 ? ScriptRuntime.toNumber(objectArray[0]) : 0.0;
        if (bl) {
            return new NativeNumber(d);
        }
        return this.wrap_double(d);
    }

    public String toString() {
        return this.js_toString(10);
    }

    private String js_toString(int n) {
        return ScriptRuntime.numberToString(this.doubleValue, n);
    }

    private String js_toLocaleString(int n) {
        return this.js_toString(n);
    }

    private String js_toFixed(Context context, Object[] objectArray) {
        return this.num_to(context, objectArray, 2, 2, -20, 100, 0);
    }

    private String js_toExponential(Context context, Object[] objectArray) {
        return this.num_to(context, objectArray, 1, 3, 0, 100, 1);
    }

    private String js_toPrecision(Context context, Object[] objectArray) {
        return this.num_to(context, objectArray, 0, 4, 1, 100, 0);
    }

    private String num_to(Context context, Object[] objectArray, int n, int n2, int n3, int n4, int n5) {
        int n6;
        if (objectArray.length == 0) {
            n6 = 0;
            n2 = n;
        } else {
            n6 = ScriptRuntime.toInt32(objectArray[0]);
            if (n6 < n3 || n6 > n4) {
                String string = ScriptRuntime.getMessage1("msg.bad.precision", ScriptRuntime.toString(objectArray[0]));
                throw NativeGlobal.constructError(context, "RangeError", string, this);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        DToA.JS_dtostr(stringBuffer, n2, n6 + n5, this.doubleValue);
        return stringBuffer.toString();
    }

    protected String getIdName(int n) {
        if (this.prototypeFlag) {
            switch (n) {
                case 1: {
                    return "constructor";
                }
                case 2: {
                    return "toString";
                }
                case 3: {
                    return "valueOf";
                }
                case 4: {
                    return "toLocaleString";
                }
                case 5: {
                    return "toFixed";
                }
                case 6: {
                    return "toExponential";
                }
                case 7: {
                    return "toPrecision";
                }
            }
        }
        return null;
    }

    protected int mapNameToId(String string) {
        if (!this.prototypeFlag) {
            return 0;
        }
        int n = 0;
        String string2 = null;
        switch (string.length()) {
            case 7: {
                char c = string.charAt(0);
                if (c == 't') {
                    string2 = "toFixed";
                    n = 5;
                    break;
                }
                if (c != 'v') break;
                string2 = "valueOf";
                n = 3;
                break;
            }
            case 8: {
                string2 = "toString";
                n = 2;
                break;
            }
            case 11: {
                char c = string.charAt(0);
                if (c == 'c') {
                    string2 = "constructor";
                    n = 1;
                    break;
                }
                if (c != 't') break;
                string2 = "toPrecision";
                n = 7;
                break;
            }
            case 13: {
                string2 = "toExponential";
                n = 6;
                break;
            }
            case 14: {
                string2 = "toLocaleString";
                n = 4;
                break;
            }
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n;
    }
}

