/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.configuration;

import com.jclark.xsl.sax.Driver;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openoffice.configuration.Generator;
import org.openoffice.configuration.Inspector;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLDefaultGenerator {
    public static final String FILE_EXT = ".xml";
    protected String packageName = null;
    protected String componentName = null;
    protected String categoryName = null;
    protected String transformationFile = null;

    public XMLDefaultGenerator(String string) throws Exception {
        System.setProperty("com.jclark.xsl.sax.parser", "org.apache.xerces.parsers.SAXParser");
        this.evaluateSchema(string);
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    protected void evaluateSchema(String string) throws Exception {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            Inspector inspector = new Inspector();
            sAXParser.parse(new File(new File(string).getAbsolutePath()).toURL().toString(), (HandlerBase)inspector);
            this.packageName = inspector.packageName;
            this.componentName = inspector.componentName;
            this.categoryName = inspector.categoryName;
            this.transformationFile = inspector.transformationFile;
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("\n** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
            System.out.println("   " + sAXParseException.getMessage());
            throw sAXParseException;
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
            throw sAXException;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw iOException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    public String getTargetName(String string, String string2) throws Exception {
        String string3 = this.packageName.replace('.', File.separatorChar);
        File file = new File(string + File.separatorChar + string2 + File.separatorChar + string3 + File.separatorChar + this.componentName + FILE_EXT);
        return file.getPath();
    }

    public void generate(String[] stringArray, boolean bl) throws Exception {
        Object object = new String[stringArray.length + 1];
        for (int i = 0; i < stringArray.length; ++i) {
            object[i] = stringArray[i];
        }
        object[1] = stringArray[1] + File.separator + this.transformationFile;
        object[3] = "path=" + Generator.getAbsolutePath(stringArray[3]);
        object[stringArray.length] = "pathSeparator=" + File.pathSeparator;
        stringArray = object;
        try {
            object = new File(stringArray[2]).getParentFile();
            ((File)object).mkdirs();
            String[] stringArray2 = null;
            if (bl) {
                stringArray2 = new String[stringArray.length + 1];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray2[i] = stringArray[i];
                }
                stringArray2[stringArray.length] = "templates=true";
            } else {
                stringArray2 = stringArray;
            }
            Driver.main((String[])stringArray2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    protected void generateInstanceFile(String[] stringArray) throws Exception {
        stringArray[2] = this.getTargetName(stringArray[2], "instance");
        this.generate(stringArray, false);
    }

    protected void generateTemplateFile(String[] stringArray) throws Exception {
        stringArray[2] = this.getTargetName(stringArray[2], "template");
        this.generate(stringArray, true);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 4) {
            System.err.println("Usage: cmd <filename> <xsldir> <outdir> <include-path> [transformation parameters]");
            System.err.println("<filename>: Configuration description file");
            System.err.println("<xsldir>: Directory where to locate the transformation files used");
            System.err.println("<outdir>: Directory where to generate the output files");
            System.err.println("<include-path>: Path where to find imported configuration files");
            System.exit(1);
        }
        try {
            XMLDefaultGenerator xMLDefaultGenerator = new XMLDefaultGenerator(stringArray[0]);
            String[] stringArray2 = new String[stringArray.length + 1];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = stringArray[i];
            }
            String string = new File(stringArray[2] + File.separator + "template").getAbsoluteFile().toURL().toString();
            stringArray2[stringArray.length] = "templateURL=" + string;
            xMLDefaultGenerator.generateInstanceFile((String[])stringArray2.clone());
            xMLDefaultGenerator.generateTemplateFile((String[])stringArray2.clone());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

